/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.emailprovider.types;

import org.apache.sling.api.resource.Resource;

/**
 * Defines interface of email/newsletter to be sent to emailprovider. The methods for name and identifier are inherited from NamedType
 */
public interface Email extends NamedType {
    
	/**
     * The email classification type would be stored as this parameter name in the email
     */
    public static final String EMAIL_CLASSIFICATION = "classification";
    
    /**
     * Get the email subject.
     * @return the subject for the email.
     */
    public String getSubject();

    /**
     * Set the email subject
     * @param subject The email subject.
     */
    public void setSubject(String subject);

    /**
     * Get the email content
     * @return The email content which could be a text or html.
     */
    public String getContent();

    /**
     * Set the email content
     * @param content The email content which could be text or html
     */
    public void setContent(String content);

    /**
     * Whether the content is plain text or HTML
     * @return true if HTML, false otherwise.
     */
    public boolean isHtml();

    /**
     * Set whether content is plain text or HTML
     * @param isHtml true if HTML, false otherwise.
     */
    public void setHtml(boolean isHtml);

    /**
     * Get the email address for sender.
     * @return the sender's email address.
     */
    public String getFromAddress();

    /**
     * Set the sender's email address.
     * @param fromAddress sender's email address
     */
    public void setFromAddress(String fromAddress);
    /**
     * Set the resource to that of associated newsletter
     * @param resource of associated newsletter
     */
	public void setResource(Resource resource);
	/**
	 * @return resource associated with newsletter
	 */
	public Resource getResource();
}
