/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.exacttarget;

import java.util.Map;


import com.day.cq.mcm.exacttarget.client.Account;
import com.day.cq.mcm.exacttarget.client.DataExtension;
import com.day.cq.mcm.exacttarget.client.DataExtensionField;
import com.day.cq.mcm.exacttarget.client.Email;
import com.day.cq.mcm.exacttarget.client.FilterPart;
import com.day.cq.mcm.exacttarget.client.ListSubscriber;
import com.day.cq.mcm.exacttarget.client.PropertyDefinition;
import com.day.cq.mcm.exacttarget.client.SendClassification;
import com.day.cq.mcm.exacttarget.client.Subscriber;
import com.day.cq.mcm.exacttarget.client.SubscriberList;
import com.day.cq.mcm.exacttarget.client.List;

/**
 * ExactTarget Webservice client that makes webservice calls to ExactTarget WebService endpoint.
 */
public interface ExactTargetClient {
    /**
     * This function calls a webservice that describes the ET subscriber parameters.
     * @return A list of properties containing personlization information provided by ExactTarget
     * @throws ExactTargetException In case of error.
     */
    public java.util.List<PropertyDefinition> describeSubscriber() throws ExactTargetException;

    /**
     * This function calls an ET webservice to fetch the subscription lists in ET.
     * @param filter custom filtering parameters to fetch the list.
     * @return The list of mailing lists available in ET.
     * @throws ExactTargetException In case of error.
     */
    public java.util.List<List> getSubscriberList(FilterPart filter)
            throws ExactTargetException;

    /**
     * This function calls an ET webservice to add a subscriber to a list.
     * @param subscriber A subscriber that needs to be added to the mailing lists specified within the subscriber {@link com.day.cq.mcm.exacttarget.client.Subscriber#setLists(SubscriberList[]) , see set lists}.
     * @throws ExactTargetException In case of error.
     */
    public void addSubscriberToList(Subscriber subscriber)
            throws ExactTargetException;

    /**
     * This fucntion calls an ET webservice to publish and Email to ET.
     * @param email The email object to be published
     * @return the published email with new properties saved on ExactTarget( like entityID)
     * @throws ExactTargetException In case of error.
     */
    public Email publishEmail(Email email) throws ExactTargetException;
    
    /**
     * This function calls an ET webservice to update published email on ExactTarget
     * @param email The email containing the updated content and ID set to that of the email to be updated on ExactTarget
     * @throws ExactTargetException
     */
    public void updateEmail(Email email) throws ExactTargetException;

    /**
     * This function calls an ET webservice to send an email through ET.
     * @param email with ID set to that of the existing email on ExactTarget which is meant to be sent. Further emailclassification({@link com.day.cq.mcm.exacttarget.client.Email#setCustomerKey(String) customerkey}) can be set. 
     * @param subscriberList The list to which mail will be sent.
     * @throws ExactTargetException In case of error.
     */

    public void sendEmail(Email email, SubscriberList subscriberList) throws ExactTargetException;

    /**
     * This function calls ET Webservice to delete a subscriber from a list.
     * @param subscriber The subscriber to be deleted from lists specified within subscriber{@link com.day.cq.mcm.exacttarget.client.Subscriber#setLists(SubscriberList[]) ,see set lists}.
     * @throws ExactTargetException In case of error.
     */
    public void deleteSubscriberFromList(Subscriber subscriber)
            throws ExactTargetException;

    /**
     * This function calls ET WebService to get all the emails for an account.
     * @param filter filtering criteria for emails (future use)
     * @return a List of emails available with the account
     * @throws ExactTargetException In case of error.
     */
    public java.util.List<Email> getEmails(FilterPart filter) throws ExactTargetException;

    /**
     * This function calls ET WebService to get all the email send classifications for an account.
     * @param filter filtering criteria for send classifications (future use)
     * @return a List of SendClassifications
     * @throws ExactTargetException In case of error.
     */
    public java.util.List<SendClassification> getSendClassifications(FilterPart filter)
            throws ExactTargetException;

    /**
     * This function calls ET WebService to send an email to a subscriber through ET.
     * @param email with ID set to that of the existing email on ExactTarget which is meant to be sent. Further emailclassification({@link com.day.cq.mcm.exacttarget.client.Email#setCustomerKey(String) customerkey}) can be set. 
     * @param subscriber The subscriber to which the email has to be sent
     * @throws ExactTargetException In case of error.
     */
    public void sendEmail(Email email, Subscriber subscriber) throws ExactTargetException;

    /**
     * This function calls ET WebService to create a list in ET.
     * @param list The list to be created
     * @return the created list.
     * @throws ExactTargetException In case of error.
     */
    public List createList(List list) throws ExactTargetException;

    /**
     * This function calls ET WebService to delete a list from ET.
     * @param listId ID of the list to be deleted
     * @throws ExactTargetException In case of error.
     */
    public void deleteList(String listId) throws ExactTargetException;

    /**
     * This function calls ET WebService to get all subscribers on a list in ET.
     * @param listId ID of the list for which subscribers need to be fetched
     * @return list of subscribers on the specified list
     * @throws ExactTargetException In case of error.
     */
    public java.util.List<ListSubscriber> getSubscribers(String listId) throws ExactTargetException;
 	/**
     * This function returns all the accounts associated with the ExactTarget configuration. If ExactTarget 
     * supports multiple accounts for a connection then those accounts can be fetched by implementing this API.
 	 * @param filter Pass null if no filtering needed.
 	 * @return A list of all Accounts associated with this connection.
 	 * @throws ExactTargetException in case of errors
 	 */
    public java.util.List<Account> getAccounts(FilterPart filter)
            throws ExactTargetException;
    /**
     * @param params The parameter to connect to ExactTarget
     * @param entityId Id of the published email/newsletter as saved on ExactTarget
     * @return Map containing LoginUrl and UserToken to view the published email on ExactTarget 
     * @throws ExactTargetException
     */
    public Map<String, String> viewPublishedNewsletter(String entityId) throws ExactTargetException;
    /**
     * This function is used to validate the connection parameters with ExactTarget provided while creating the ExactTarget cloudservice configuration
     * @throws EmailServiceException in case of errors.
     */
    public void checkCredentials() throws ExactTargetException;    
    /**
     * This function is used to retrieve filtered  {@link com.day.cq.mcm.exacttarget.client.DataExtension data extension} objects. 
     * @param properties The properties of the data extension to be retrieved.
     * @param filter {@link com.day.cq.mcm.exacttarget.client.FilterPart Filter} to be applied while retrieving, e.g, IsSendable equals true
     * @return A list of DataExtension objects 
     * @throws ExactTargetException in case of errors
     */
    public java.util.List<DataExtension> retrieveDataExtension(String[] properties, FilterPart filter) throws ExactTargetException;
    /**
     * This function is used to retrieve data extension {@link com.day.cq.mcm.exacttarget.client.DataExtensionField columns} 
     * from the data extension specified in the filter
     * @param filter Filter should specify the DataExtension whose columns are to be retrieved, e.g., DataExtension.CustomerKey equals *****  
     * @param fields Attributes of the columns, e.g., Name, DefaultValue, {@ link com.day.cq.mcm.exacttarget.client.FileType fieldType} etc.
     * @return A list of data extension {@link com.day.cq.mcm.exacttarget.client.DataExtensionField column fields}
     * @throws ExactTargetException in case of errors
     */
    public java.util.List<DataExtensionField> retrieveDataExtensionFields(FilterPart filter, String[] fields)throws ExactTargetException;
}
