/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.exacttarget;

import com.day.cq.mcm.emailprovider.EmailService;
import com.day.cq.mcm.emailprovider.types.ConnectionParams;
import com.day.cq.mcm.exacttarget.client.Account;
import com.day.cq.mcm.exacttarget.client.DataExtension;
import com.day.cq.mcm.exacttarget.client.DataExtensionField;
import com.day.cq.mcm.exacttarget.client.Email;
import com.day.cq.mcm.exacttarget.client.FilterPart;
import com.day.cq.mcm.exacttarget.client.List;
import com.day.cq.mcm.exacttarget.client.ListSubscriber;
import com.day.cq.mcm.exacttarget.client.PropertyDefinition;
import com.day.cq.mcm.exacttarget.client.SendClassification;
import com.day.cq.mcm.exacttarget.client.Subscriber;
import com.day.cq.mcm.exacttarget.client.SubscriberList;
import com.day.cq.wcm.webservicesupport.Configuration;


import java.util.Map;

public interface ExactTargetService extends EmailService {
 	/**
     * This function returns all the accounts associated with the ExactTarget configuration. If ExactTarget 
     * supports multiple accounts for a connection then those accounts can be fetched by implementing this API.
 	 * @param connectionParams The connection parameters to connect to ExactTarget.
 	 * @param filter Pass null if no filtering needed.
 	 * @return A list of all Accounts associated with this connection.
 	 * @throws ExactTargetException in case of errors
 	 */
	public java.util.List<Account> getAccounts(ConnectionParams connectionParams,FilterPart filter) throws ExactTargetException ;
    /**
     * This function is used to validate the connection parameters associated with ExactTarget
     * @param params The ConnectionParams for ExactTarget. 
     * @throws ExactTargetException in case of errors.
     */
	public void checkCredentials(ConnectionParams connectionParams) throws ExactTargetException;
    /**
     * This function is used to add a subscriber to subscription lists.
     * @param configuration ExactTarget configuration from cloud services.
     * @param subscriber The Subscriber object containing information about the subscriber and the subscription lists{@link com.day.cq.mcm.exacttarget.client.Subscriber#setLists(SubscriberList[])}..
     * @throws ExactTargetException in case of errors.
     */
	public void addSubscriberToList(Configuration configuration,Subscriber subscriber) throws ExactTargetException;
    /**
     * This function is used to delete a subscriber to subscription lists.
     * @param configuration ExactTarget configuration from cloud services.
     * @param subscriber The Subscriber object containing information about the subscriber and the subscription lists{@link com.day.cq.mcm.exacttarget.client.Subscriber#setLists(SubscriberList[])}..
     * @throws ExactTargetException in case of errors.
     */	
    public void deleteSubscriberFromList(Configuration configuration,Subscriber subscriber) throws ExactTargetException;
    /**
     * This function is used to publish an email to ExactTarget.
     * @param configuration ExactTarget configuration from cloud services.
     * @param email The email to be published
     * @return the published email with new properties(entityID: identifier of email on ET) saved on ExactTarget 
     * @throws ExactTargetException in case of errors.
     */    
    public Email publishEmail(Configuration configuration, Email email) throws ExactTargetException;
    /**
     * This function is used to update a published email on an external email provider
     * @param configuration ExactTarget configuration from cloud services
     * @param email The email containing the updates with ID set to corresponding email entity on ExactTarget
     * @throws ExactTargetException
     */    
    public void updateEmail(Configuration configuration, Email email) throws ExactTargetException ;
    /**
     * This function is used to send an email to a subscriber.
     * @param configuration ExactTarget configuration from cloud services.
     * @param email Email object containing information about email like ID and customerKey
     * @param subscriber The subscriber to which the email will be sent.
     * @throws ExactTargetException in case of errors.
     */    
    public void sendEmail(Configuration configuration, Email email,Subscriber subscriber) throws ExactTargetException;
    /**
     * This function is used to send an email to a subscriberList.
     * @param configuration ExactTarget configuration from cloud services.
     * @param email Email object containing information about email like ID and customerKey
     * @param subscriberList The list to which the email will be sent.
     * @throws ExactTargetException in case of errors.
     */    
    public void sendEmail(Configuration configuration,Email email, SubscriberList subcriberList) throws ExactTargetException;
    /**
     * This function will get all the subscribers that are subscribed on the specified list.
     * @param configuration ExactTarget configuration from cloud services.
     * @param listId identifier of the subscription list for which subscribers need to be fetched.
     * @return A list containing all the subscriber objects subscribed to the list.
     * @throws ExactTargetException in case of errors.
     */
    public java.util.List<ListSubscriber> getSubscribers(Configuration configuration, String listId) throws ExactTargetException;
    /**
     * This function will delete specified subscription list from ExactTarget. 
     * @param configuration ExactTarget configuration from cloud services.
     * @param listId The identifier of the subscription list to be deleted.
     * @throws ExactTargetException in case of errors.
     */    
	public void deleteList(Configuration configuration, String listId) throws ExactTargetException ;
    /**
     * This function will create a subscription list on ExactTarget. 
     * @param configuration ExactTarget configuration from cloud services.
     * @param list List containing information on the list to be created
     * @throws ExactTargetException in case of errors.
     */	
	public List createList(Configuration configuration, List list) throws ExactTargetException ;
    /** 
     * This function returns the Classification types for sending an email.
     * @param configuration ExactTarget configuration from cloud services.
     * @param filter Filter containing send classification filters, pass null for no filtering. 
     * @return A List containing all SendClassification objects for the available classifications.
     * @throws ExactTargetException in case of errors.
     */	
	public java.util.List<SendClassification> getSendClassifications(Configuration configuration, FilterPart filter) throws ExactTargetException;

    /**
     * This function will get a list of all mails that are available with ExactTarget for this account.
     * @param configuration ExactTarget configuration from cloud services.
     * @param filter Filter containing Email filters. Pass null for no filter.
     * @return A list containing all Email objects.
     * @throws ExactTargetException in case of errors.
     */	
	public java.util.List<Email> getEmails(Configuration configuration,FilterPart filter) throws ExactTargetException;
	/**
	 * This operation is specific to ExactTarget
	 * @param params The parameter to connect to ExactTarget
	 * @param entityId Id of the published email/newsletter as saved on ExactTarget
	 * @return Map containing LoginUrl and UserToken to view the published email on ExactTarget. A post request from browser on the LoginUrl with post param UserToken will open the  
	 * published email on ExactTarget.
	 * @throws ExactTargetException
	 */	
	public Map<String,String> viewPublishedNewsletter(Configuration configuration,String entityId) throws ExactTargetException;
    /**
     * This function is used to return all subscription lists available with ExactTarget account.
     * @param configuration ExactTarget configuration from cloud services.
     * @param filter Filter containing list filters. Pass null for no filter.
     * @return a List containing ET List objects for each subscription list available with ExactTarget account.
     * @throws ExactTargetException in case of errors.
     */	
    public java.util.List<List> getSubscriberList(Configuration configuration, FilterPart filter) throws ExactTargetException;
    /**
     * This function fetches the personalisation elements from ExactTarget
     * @param configuration ExactTarget Configuration from cloud services 
     * @return List containing PropertyDefinition available on ExactTarget 
     * @throws ExactTargetException in case of errors.
     */    
    public java.util.List<PropertyDefinition> describeSubscriber(Configuration configuration) throws ExactTargetException;
    /**
     * This function is used to retrieve filtered  {@link com.day.cq.mcm.exacttarget.client.DataExtension data extension} objects.
     * @param configuration ExactTarget Configuration from cloud services 
     * @param properties The properties of the data extension to be retrieved.
     * @param filter {@link com.day.cq.mcm.exacttarget.client.FilterPart Filter} to be applied while retrieving, e.g, IsSendable equals true
     * @return A list of DataExtension objects 
     * @throws ExactTargetException in case of errors
     */
    public java.util.List<DataExtension> retrieveDataExtension(Configuration configuration, String[] properties, FilterPart filter) throws ExactTargetException;
    /**
     * This function is used to retrieve data extension {@link com.day.cq.mcm.exacttarget.client.DataExtensionField columns} 
     * from the data extension specified in the filter
     * @param configuration ExactTarget Configuration from cloud services
     * @param filter Filter should specify the DataExtension whose columns are to be retrieved, e.g., DataExtension.CustomerKey equals *****  
     * @param fields Attributes of the columns, e.g., Name, DefaultValue, {@ link com.day.cq.mcm.exacttarget.client.FileType fieldType} etc.
     * @return A list of data extension {@link com.day.cq.mcm.exacttarget.client.DataExtensionField column fields}
     * @throws ExactTargetException in case of errors
     */
    public java.util.List<DataExtensionField> retrieveDataExtensionFields(Configuration configuration, FilterPart filter, String[] fields)throws ExactTargetException;
}
