/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.landingpage.leadform.creator;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.i18n.I18n;
import com.day.cq.mcm.landingpage.leadform.LeadFormParagraphPostProcessor;
import com.day.cq.wcm.api.Page;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.engine.SlingRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;


/**
 * This CTA lead forms handling servlet accepts POSTs to a form begin paragraph but only if the selector "cta-form" and the extension "html"
 * is used.
 */
@Component
@Service(value = LeadFormsCreator.class)
public class LeadFormsCreator

{

    public static final String FORMSTART = ":formstart";
    public static final String REP_USER_ID = "rep:userId";
    public static final String EMAIL = "email";
    public static final String AUTHORIZABLE_ID = "authorizableId";

    public static final String REP_PASSWORD = "rep:password";
    public static final String CQ_AUTHORIZABLE_CATEGORY = "cq:authorizableCategory";
    public static final String MCM = "mcm";
    public static final String GROUP_NAME = "groupName";
    public static final String CREATE_GROUP = "createGroup";
    public static final String CREATE_USER = "createUser";
    public static final String ADD_MEMBERS = "addMembers";
    public static final String LIBS_GRANITE_SECURITY_POST_AUTHORIZABLES = "/libs/granite/security/post/authorizables";

    //error codes
    public static final String ERR_01 = "Err_01"; //"UserId and email, both cannot be null or empty";
    public static final String ERR_02 = "Err_02"; //"Please enter a valid list for unsubscription";
    public static final String ERR_03 = "Err_03"; //"Please enter a valid list for unsubscription"
    public static final String ERR_04 = "Err_04"; //"Pleaser enter a valid user id for unsubscription"

    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "cta-form";
    protected static final String ATTR_RESOURCE = LeadFormsCreator.class.getName() + "/resource";
    protected final static String PARAM_GROUP_NAME = "groupName";
    protected static final String PARAM_INTERMEDIATE_PATH = "intermediatePath";
    protected final static String PARAM_PASSWORD = "rep:password";
    protected final static String PARAM_SUBMIT = "Submit";
    public static final String PROFILE_PATH = "path";
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    private static final Set<String> RESERVED = new HashSet<String>();

    static {
        RESERVED.add(PARAM_GROUP_NAME);
        RESERVED.add(AUTHORIZABLE_ID);
        RESERVED.add(CQ_AUTHORIZABLE_CATEGORY);
        RESERVED.add(PARAM_PASSWORD);
        RESERVED.add(CREATE_USER);
        RESERVED.add(FORMSTART);
        RESERVED.add(PARAM_SUBMIT);

    }

    @Reference
    private RequestResponseFactory requestResponseFactory;
    @Reference
    private SlingRequestProcessor slingRequestProcessor;


    /**
     * Return all form elements for this form.
     *
     * @param formResource
     * @return An iterator for all form elements.
     */
    public static Iterator<Resource> getFormElements(final Resource formResource) {
        final List<Resource> list = new ArrayList<Resource>();
        // get all siblings
        final Iterator<Resource> iter = ResourceUtil.listChildren(ResourceUtil.getParent(formResource));
        // while ( !iter.next().getPath().equals(formResource.getPath()) );
        collectFormElements(list, iter);
        return list.iterator();
    }

    /**
     * Helper method to collect all form elements.
     *
     * @param list
     * @param iter
     * @return
     */
    private static boolean collectFormElements(final List<Resource> list, final Iterator<Resource> iter) {
        boolean stop = false;
        while (!stop && iter.hasNext()) {
            final Resource n = iter.next();
            if (n.getResourceType().startsWith(LeadFormParagraphPostProcessor.RT_LEAD_FORM_PREFIX)
                    || (n.getResourceSuperType() != null && n.getResourceSuperType().startsWith(
                    LeadFormParagraphPostProcessor.RT_LEAD_FORM_PREFIX))) {
                list.add(n);
            } else {
                // do deep search
                final Iterator<Resource> cI = ResourceUtil.listChildren(n);
                if (cI != null) {
                    stop = collectFormElements(list, cI);
                }
            }
        }
        return stop;
    }

    /**
     * Prints lead form title with style provided in "className"
     *
     * @param fieldId
     * @param title
     * @param required
     * @param hideLabel
     * @param className
     * @param out
     * @throws IOException
     */
    public static void printTitle(String fieldId, String title, boolean required, boolean hideLabel, String className, Writer out)
            throws IOException {
        out.write("<div class=\"form_leftcol\"");
        if (hideLabel) {
            out.write(" style=\"display: none;\"");
        }
        if (title != null && title.length() > 0) {
            title = StringEscapeUtils.escapeHtml4(title);
        } else {
            title = "&nbsp;";
        }
        out.write(">");
        String titileClassName = "form_leftcollabel" + (!StringUtils.isEmpty(className) ? " " + className : "");
        titileClassName = StringEscapeUtils.escapeHtml4(titileClassName);
        out.write("<div class=\"" + titileClassName + "\">");
        if (fieldId != null) {
            fieldId = StringEscapeUtils.escapeHtml4(fieldId);
            out.write("<label for=\"" + fieldId + "\">" + title + "</label>");
        } else {
            out.write("<span>" + title + "</span>");
        }
        out.write("</div>");
        out.write("<div class=\"form_leftcolmark\">");
        if (!hideLabel) {
            if (required) {
                out.write(" *");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</div>");
        out.write("</div>\n");
    }

    private static String getParameter(Resource resource, HttpServletRequest request, String paramName) {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            final ValueMap values = ResourceUtil.getValueMap(resource);
            paramValue = values.get(paramName, String.class);
        }
        return paramValue;
    }

    /**
     * This method is used to redirect the user to the url provided by author in lead form. By default lead will be re-directed to the same
     * page after successful form submit.
     *
     * @param containingPage
     * @param extension
     * @param isError
     * @param request
     * @param response
     * @throws IOException
     */
    public void redirectUrl(Page containingPage, String extension, String errorCode, HttpServletRequest request, HttpServletResponse response)
            throws IOException, ServletException {
        String redirectUrl = request.getParameter(":redirect");
        if (redirectUrl != null && !AuthUtil.isRedirectValid(request, redirectUrl)) {
            logger.error("Invalid redirect specified: ", redirectUrl);
            redirectUrl = containingPage.getPath() + "." + EXTENSION;
        }

        logger.info(containingPage.getContentResource().getResourceType());
        if (errorCode != null || redirectUrl == null) {
            request.getSession().setAttribute("errorCode", errorCode);
            if( containingPage.getContentResource().isResourceType("geometrixx/components/newsletterpage")){
                redirectUrl =  request.getContextPath() + containingPage.getPath() + ".emailclient" + extension;
            } else {
                redirectUrl =  request.getContextPath() + containingPage.getPath() + extension;
            }

        }
        response.sendRedirect(redirectUrl);
    }

    public void unSubscribe() {

    }

    /**
     * @deprecated Deprecated since version 1.2.4 of the cq-mcm-landingpage bundle
     * and no longer used. Leads may be created without having a password specified.
     */
    public String createPassword() {
        String pwdChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
        String password = "";
        for (int i = 0; i < 12; i++) {
            password += pwdChars.charAt((int) (Math.random() * pwdChars.length()));
        }
        return password;
    }

    public void createAuthLead(SlingHttpServletRequest request,
                               SlingHttpServletResponse response) throws ServletException, IOException, RepositoryException {

        Map<String, Object> params = request.getParameterMap();
        ResourceResolver resolver = request.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);

        String authId = validateAndGetAuthId(params);
        org.apache.jackrabbit.api.security.user.UserManager userManager = request.getResourceResolver().adaptTo(org.apache.jackrabbit.api.security.user.UserManager.class);

        org.apache.jackrabbit.api.security.user.Authorizable userAuth = userManager.getAuthorizable(authId);

        //create or update lead
        if (userAuth == null) {
            createAuthorizable(request, authId, false);
            userAuth = userManager.getAuthorizable(authId);
            addProfileProperties(request, params, userAuth);
        }


        //check if form contains groupName, Call authorizable servlet to create group
        if (params.containsKey(GROUP_NAME)) {
            String groupName = ((String[]) params.get(GROUP_NAME))[0];
            if (groupName == null || groupName.trim().equals(""))
                return;

            org.apache.jackrabbit.api.security.user.Authorizable groupAuth = userManager.getAuthorizable(groupName);

            if (groupAuth == null) {
                createAuthorizable(request, authId, true);
            } else {
                ((org.apache.jackrabbit.api.security.user.Group) groupAuth).addMember(userAuth);
                session.save();

            }

        }


    }

    public void removeLeadFromGroup(SlingHttpServletRequest request) throws ServletException, IOException, RepositoryException {
        Map<String, Object> params = request.getParameterMap();
        String userId = validateAndGetAuthId(params);
        org.apache.jackrabbit.api.security.user.UserManager userManager = request.getResourceResolver().adaptTo(org.apache.jackrabbit.api.security.user.UserManager.class);

        if (!params.containsKey(GROUP_NAME))
            throw new RuntimeException(ERR_02);

        if (((String[]) params.get(GROUP_NAME)) == null || ((String[]) params.get(GROUP_NAME))[0].trim().equals(""))
            throw new RuntimeException(ERR_02);

        String groupName = ((String[]) params.get(GROUP_NAME))[0];
        org.apache.jackrabbit.api.security.user.Authorizable groupAuth = userManager.getAuthorizable(groupName);

        org.apache.jackrabbit.api.security.user.Authorizable userAuth = userManager.getAuthorizable(userId);

        if (groupAuth == null || !groupAuth.isGroup())
            throw new RuntimeException(ERR_03);

        if(userAuth == null)
            throw new RuntimeException(ERR_04);

        ((org.apache.jackrabbit.api.security.user.Group) groupAuth).removeMember(userAuth);
        Session session = request.getResourceResolver().adaptTo(Session.class);
        session.save();
    }


    private String validateAndGetAuthId(Map<String, Object> params) {
        if (params.containsKey(REP_USER_ID)) {
            Object value = params.get(REP_USER_ID);
            if (value != null && !((String[]) value)[0].trim().equals("")) {
                return ((String[]) params.get(REP_USER_ID))[0];
            }
        }

        if (params.containsKey(EMAIL)) {
            Object value = params.get(EMAIL);
            if (value != null && !((String[]) value)[0].trim().equals("")) {
                return ((String[]) params.get(EMAIL))[0];
            }
        }

        throw new SlingException(ERR_01, new Exception());

    }

    private void createAuthorizable(SlingHttpServletRequest request, String authId, boolean createGroup) throws ServletException, IOException, RepositoryException {

        Map<String, Object> params = request.getParameterMap();
        Map<String, Object> parameters = new HashMap<String, Object>();

        //add authorizable category
        parameters.put(CQ_AUTHORIZABLE_CATEGORY, new String[]{MCM});

        if (!createGroup) {
            if (params.containsKey(PARAM_PASSWORD)) {
                parameters.put(PARAM_PASSWORD, params.get(PARAM_PASSWORD));
            }
            parameters.put(CREATE_USER, "");
            parameters.put(AUTHORIZABLE_ID, authId);
        } else {
            parameters.put(CREATE_GROUP, "");
            parameters.put(ADD_MEMBERS, authId);
            parameters.put(AUTHORIZABLE_ID, ((String[]) params.get(GROUP_NAME))[0]);
        }

        HttpServletRequest req = requestResponseFactory.createRequest(request.getMethod(), "/libs/granite/security/post/authorizables", parameters);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HttpServletResponse res = requestResponseFactory.createResponse(stream);
        slingRequestProcessor.processRequest(req, res, request.getResourceResolver());
        String htmlresponse = stream.toString();
        logger.debug(htmlresponse);
        if (htmlresponse.contains("Exception") || htmlresponse.contains("Error")) {
            int messageTagIndex = htmlresponse.indexOf("<div id=\"Message\">");
            String messageSubstring = htmlresponse.substring(messageTagIndex);
            int messageTagEndTagIndex = messageSubstring.indexOf("</div>");
            String errorMessage = messageSubstring.substring(0, messageTagEndTagIndex);

            throw new RuntimeException(errorMessage);
        }
    }

    private void addProfileProperties(SlingHttpServletRequest request, Map<String, Object> parameters, org.apache.jackrabbit.api.security.user.Authorizable auth) throws ServletException, IOException, RepositoryException {
        Map<String, Object> updateParameters = new HashMap<String, Object>();
        for (String key : parameters.keySet()) {
            if (RESERVED.contains(key)) {
                continue;
            }
            Object value = parameters.get(key);
            updateParameters.put(key, value);
        }

        updateParameters.put(PROFILE_PATH, "profile");
        HttpServletRequest req = requestResponseFactory.createRequest(request.getMethod(), auth.getPath() + ".userproperties.html", updateParameters);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HttpServletResponse res = requestResponseFactory.createResponse(stream);

        slingRequestProcessor.processRequest(req, res, request.getResourceResolver());
        String htmlresponse = stream.toString();
        logger.debug(htmlresponse);
        if (htmlresponse.contains("Exception") || htmlresponse.contains("Error")) {
            int messageTagIndex = htmlresponse.indexOf("<div id=\"Message\">");
            String messageSubstring = htmlresponse.substring(messageTagIndex);
            int messageTagEndTagIndex = messageSubstring.indexOf("</div>");
            String errorMessage = messageSubstring.substring(0, messageTagEndTagIndex);

            throw new RuntimeException(errorMessage);
        }
    }

}
