/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.landingpage.parser.taghandlers.cta;

import java.util.HashMap;
import java.util.Map;

import javax.jcr.RepositoryException;

import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

import com.day.cq.commons.DownloadResource;
import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;

/**
 * The <code>GraphicalClickThroughComponentTagHandler</code> handles the CTA graphical link component. Maps attribute provided in imported
 * zip to graphical link component and provides accessibility to change or add any additional properties.
 * 
 * @author nidhgupt
 */
public class GraphicalClickThroughComponentTagHandler extends AbstractTagHandler {

    private Logger logger = LoggerFactory.getLogger(GraphicalClickThroughComponentTagHandler.class);

    private Map<String, Object> base = new HashMap<String, Object>();

    private String suffix;

    private String resourceType;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);

        if ("a".equalsIgnoreCase(localName)) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) modAttibutes.removeAttribute(index);

            startElement(uri, localName, qName, modAttibutes);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        if (StringUtils.equalsIgnoreCase("a", localName)) {
            base.put("targetURL", atts.getValue("href"));
            base.put("hrefTargets", atts.getValue("target"));
            base.put("anchorCss", atts.getValue("class"));
            base.put("anchorId", atts.getValue("id"));
        } else if (StringUtils.equalsIgnoreCase("img", localName)) {
            base.put(DownloadResource.PN_REFERENCE, getDesignPath() + "/" + atts.getValue("src"));
            String titleValue = atts.getValue("title");
            base.put("jcr:title", titleValue);
            String altValue = atts.getValue("alt");
            base.put("alt", altValue);
            base.put("height", atts.getValue("height"));
            base.put("width", atts.getValue("width"));
            base.put("imgCss", atts.getValue("class"));
            base.put("imgId", atts.getValue("id"));
            if (altValue == null || altValue.trim().equals("")) {
                base.put("alt", titleValue);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        String chars = new String(ch).substring(start, start + length)/* .replace('\n', ' ').replace('\t', ' ').trim() */;
        if (chars.length() > 0) {

        }
    }

    private String getDesignPath() {
        try {
            return designImporterContext.designNode.getPath();
        } catch (RepositoryException e) {
            logger.error("A repository exception occured while trying to obtain the design path from the landing page context", e);
        }
        return "";
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if ("a".equalsIgnoreCase(localName)) {
            endElement(uri, localName, qName);
        }
        
        ValueMap properties = new ValueMapDecorator(base);
        suffix = designImporterContext.componentSuffixGenerator.getSuffix("clickthroughgraphicallink");
        PageComponent textComponent = pageBuilder.createComponent(resourceType, properties, getNameHint());
        getPageComponents().add(textComponent);
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP)
            return true;
        else
            return false;
    }

    private String getNameHint() {
        return "graphicallink" + suffix;
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {

        if (htmlContentType == HTMLContentType.MARKUP) {
            String cqIncludeJspTag = "<sling:include path=" + "\"" + getNameHint() + "\"" + "/>";

            return componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(componentDivStartTag);

        }

        return null;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }
}
