/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.landingpage.parser.taghandlers.cta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.day.cq.wcm.designimporter.util.TagUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.xml.sax.Attributes;

import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;

/**
 * The <code>LeadFormCTAComponentTagHandler</code> handles the CTA Lead Form component. Maps various lead form fields to corresponding lead
 * components and other generic components with corresponding attributes/properties provided in imported zip.
 * Supported components  are:
 * "mcm/components/cta-form/start"
 "mcm/components/cta-form/end"
 "mcm/components/cta-form/first-name"
 "mcm/components/cta-form/last-name"
 "mcm/components/cta-form/emailId"
 "mcm/components/cta-form/address"
 "mcm/components/cta-form/gender"
 "mcm/components/cta-form/dateOfBirth"
 "mcm/components/cta-form/about"
 "mcm/components/cta-form/userId"
 "mcm/components/cta-form/submit"
 "foundation/components/form/text"
 "foundation/components/form/checkbox"
 "foundation/components/form/radio"
 "foundation/components/form/password"
 "foundation/components/form/hidden"
 "foundation/components/parsys"

 Custom component can be included inside cta-form by providing full path inside data-cq-component.
 *
 * @author nidhgupt
 */
public class LeadFormCTAComponentTagHandler extends AbstractTagHandler {

    static public final String RESOURCE_TYPE_CTA_LEADFORM_START = "mcm/components/cta-form/start";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_END = "mcm/components/cta-form/end";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_FIRSTNAME = "mcm/components/cta-form/first-name";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_LASTNAME = "mcm/components/cta-form/last-name";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_EMAILID = "mcm/components/cta-form/emailId";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_ADDRESS = "mcm/components/cta-form/address";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_GENDER = "mcm/components/cta-form/gender";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_DOB = "mcm/components/cta-form/dateOfBirth";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_ABOUT = "mcm/components/cta-form/about";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_USERID = "mcm/components/cta-form/userId";

    static public final String RESOURCE_TYPE_CTA_LEADFORM_SUBMIT = "mcm/components/cta-form/submit";

    static public final String RESOURCE_TYPE_TEXT = "foundation/components/form/text";

    static public final String RESOURCE_TYPE_CHECKBOX = "foundation/components/form/checkbox";

    static public final String RESOURCE_TYPE_RADIO = "foundation/components/form/radio";

    static public final String RESOURCE_TYPE_PASSWORD = "foundation/components/form/password";

    static public final String RESOURCE_TYPE_HIDDEN = "foundation/components/form/hidden";

    static public final String RESOURCE_TYPE_PARSYS = "foundation/components/parsys";

    static private final String FORM_START = "start";

    static private final String FORM_END = "form_end";

    private String labelBuffer;

    private String labelForParameter;

    private String redirectUrl;

    private String groupName;

    private String parsysHintName;

    static private Map<String, String> supportedSubComponents = new HashMap<String, String>();

    private Map<Integer, String> orderedMapForComponents = new HashMap<Integer, String>();

    private int componentCounter = 0;

    static {
        supportedSubComponents.put("firstName", RESOURCE_TYPE_CTA_LEADFORM_FIRSTNAME);
        supportedSubComponents.put("lastName", RESOURCE_TYPE_CTA_LEADFORM_LASTNAME);
        supportedSubComponents.put("emailId", RESOURCE_TYPE_CTA_LEADFORM_EMAILID);
        supportedSubComponents.put("address", RESOURCE_TYPE_CTA_LEADFORM_ADDRESS);
        supportedSubComponents.put("dob", RESOURCE_TYPE_CTA_LEADFORM_DOB);
        supportedSubComponents.put("userId", RESOURCE_TYPE_CTA_LEADFORM_USERID);
        supportedSubComponents.put("about", RESOURCE_TYPE_CTA_LEADFORM_ABOUT);
        supportedSubComponents.put("gender", RESOURCE_TYPE_CTA_LEADFORM_GENDER);
        supportedSubComponents.put("submit", RESOURCE_TYPE_CTA_LEADFORM_SUBMIT);

        supportedSubComponents.put("text", RESOURCE_TYPE_TEXT);
        supportedSubComponents.put("checkbox", RESOURCE_TYPE_CHECKBOX);
        supportedSubComponents.put("radio", RESOURCE_TYPE_RADIO);
        supportedSubComponents.put("hidden", RESOURCE_TYPE_HIDDEN);
        supportedSubComponents.put("password", RESOURCE_TYPE_PASSWORD);
    }

    private Map<String, ComponentDetails> ctaFormSubComponents = new HashMap<String, ComponentDetails>();

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);

        if ("form".equalsIgnoreCase(localName)) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) modAttibutes.removeAttribute(index);

            startElement(uri, localName, qName, modAttibutes);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        if (StringUtils.equalsIgnoreCase("input", localName)) {
            String name = atts.getValue("name");
            if (name != null) {
                if (supportedSubComponents.containsKey(name.trim())) {
                    ComponentDetails detail = ctaFormSubComponents.containsKey(name)
                            ? ctaFormSubComponents.get(name)
                            : new ComponentDetails(getNameHint(name));
                    detail.setResourceType(supportedSubComponents.get(name));
                    detail.getProperties().put("sling:resourceSuperType","foundation/components/form/defaults/field");
                    ctaFormSubComponents.put(name, detail);
                    orderedMapForComponents.put(componentCounter++, name);
                    if (atts.getValue("class") != null) {
                        detail.getProperties().put("css", atts.getValue("class"));
                    }
                    if (atts.getValue("value") != null) {
                        detail.getProperties().put("value", atts.getValue("value"));
                    }
                    if (atts.getValue("id") != null) {
                        detail.getProperties().put("id", atts.getValue("id"));
                    }
                    if (atts.getValue("name") != null) {
                        detail.getProperties().put("name", atts.getValue("name"));
                    }

                } else if (name.equalsIgnoreCase("redirectUrl") && atts.getValue("value") != null) {
                    redirectUrl = atts.getValue("value");
                    ComponentDetails formStart = ctaFormSubComponents.get(FORM_START);
                    formStart.getProperties().put("redirect", redirectUrl);
                } else if (name.equalsIgnoreCase("groupName") && atts.getValue("value") != null) {
                    groupName = atts.getValue("value");
                    ComponentDetails formStart = ctaFormSubComponents.get(FORM_START);
                    formStart.getProperties().put("groupName", groupName);
                } else {
                    String type = atts.getValue("type");
                    if (type != null && supportedSubComponents.containsKey(type)) {
                        // String uniqueId = name;
                        ComponentDetails detail = ctaFormSubComponents.containsKey(name)
                                ? ctaFormSubComponents.get(name)
                                : new ComponentDetails(getNameHint(name));
                        detail.setResourceType(supportedSubComponents.get(type));

                        ctaFormSubComponents.put(name, detail);
                        orderedMapForComponents.put(componentCounter++, name);
                        if (atts.getValue("class") != null) {
                            detail.getProperties().put("css", atts.getValue("class"));
                        }
                        if (atts.getValue("name") != null) {
                            detail.getProperties().put("name", atts.getValue("name"));
                        }
                        if (atts.getValue("id") != null) {
                            detail.getProperties().put("id", atts.getValue("id"));
                        }
                    }
                }

            }

        } else if (StringUtils.equalsIgnoreCase("form", localName)) {
            String name = FORM_START;
            ComponentDetails detail = ctaFormSubComponents.containsKey(name) ? ctaFormSubComponents.get(name) : new ComponentDetails(
                getNameHint(name));
            detail.setResourceType(RESOURCE_TYPE_CTA_LEADFORM_START);
            ctaFormSubComponents.put(name, detail);
            orderedMapForComponents.put(componentCounter++, name);
            if (atts.getValue("class") != null) {
                detail.getProperties().put("css", atts.getValue("class"));
            }
            if (atts.getValue("id") != null) {
                detail.getProperties().put("id", atts.getValue("id"));
            }

        } else if (StringUtils.equalsIgnoreCase("select", localName)) {
            String name = atts.getValue("name");

            if (name != null) {
                if (supportedSubComponents.containsKey(name.trim())) {
                    ComponentDetails detail = ctaFormSubComponents.containsKey(name)
                            ? ctaFormSubComponents.get(name)
                            : new ComponentDetails(getNameHint(name));
                    detail.setResourceType(supportedSubComponents.get(name));

                    ctaFormSubComponents.put(name, detail);
                    orderedMapForComponents.put(componentCounter++, name);
                    if (atts.getValue("class") != null) {
                        detail.getProperties().put("css", atts.getValue("class"));
                    }
                    if (atts.getValue("id") != null) {
                        detail.getProperties().put("id", atts.getValue("id"));
                    }

                }
            }
        } else if (StringUtils.equalsIgnoreCase("label", localName)) {
            String labelFor = atts.getValue("for");
            if (labelFor != null ) {
                this.labelForParameter = labelFor;
                ComponentDetails detail = ctaFormSubComponents.containsKey(labelForParameter)
                        ? ctaFormSubComponents.get(labelForParameter)
                        : new ComponentDetails(getNameHint(labelForParameter));
                if (atts.getValue("class") != null) detail.getProperties().put("titleCss", atts.getValue("class"));
                if (atts.getValue("id") != null) {
                    detail.getProperties().put("id", atts.getValue("id"));
                }
                ctaFormSubComponents.put(labelForParameter, detail);
            }

        }
        super.startElement(uri, localName, qName, atts);

    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        String chars = new String(ch).substring(start, start + length).replace('\n', ' ').replace('\t', ' ').trim();
        if (chars.length() > 0) {
            labelBuffer = chars;
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);

        if ("form".equalsIgnoreCase(localName)) {
            endElement(uri, localName, qName);
        }

    }

    @Override
    public void endElement(String uri, String localName, String qName) throws DesignImportException {

        // end handling of form, avoid calling each and every tag handling
        if (StringUtils.equalsIgnoreCase("form", localName)) {
            parsysHintName = getNameHint("par");
            ValueMapDecorator valueMapDecorator = new ValueMapDecorator(new HashMap<String, Object>());
            valueMapDecorator.put(NAME_HINT_PROPERTY_KEY, parsysHintName);
            PageComponent parsys = pageBuilder.createComponent(RESOURCE_TYPE_PARSYS, valueMapDecorator, parsysHintName);
            Set<Integer> keySet = orderedMapForComponents.keySet();
            List<Integer> keysToBeSorted = new ArrayList<Integer>(keySet);
            Collections.sort(keysToBeSorted);
            for (Integer subComponent : keysToBeSorted) {
                ComponentDetails detail = ctaFormSubComponents.get(orderedMapForComponents.get(subComponent));
                // special handling for checkbox and radio label
                if ((detail.getResourceType().equals(RESOURCE_TYPE_RADIO) || detail.getResourceType().equals(RESOURCE_TYPE_CHECKBOX))
                    && detail.getProperties().containsKey(JcrConstants.JCR_TITLE)) {
                    String title = (String) detail.getProperties().get(JcrConstants.JCR_TITLE);
                    detail.getProperties().remove(JcrConstants.JCR_TITLE);
                    detail.getProperties().put("options", title);
                    detail.getProperties().put("hideTitle", true);
                }
                if (detail.getResourceType().equals(RESOURCE_TYPE_CTA_LEADFORM_SUBMIT) && detail.getProperties().containsKey("value")) {
                    String value = (String) detail.getProperties().get("value");
                    detail.getProperties().put(JcrConstants.JCR_TITLE, value);
                    detail.getProperties().put("hideTitle", true);
                }
                PageComponent textComponent = pageBuilder.createComponent(detail.getResourceType(),
                    new ValueMapDecorator(detail.getProperties()), detail.getHintName());

                parsys.getChildComponents().add(textComponent);
            }
            // adding end of form
            String name = FORM_END;
            ComponentDetails detail = ctaFormSubComponents.containsKey(name) ? ctaFormSubComponents.get(name) : new ComponentDetails(
                getNameHint(name));
            detail.setResourceType(RESOURCE_TYPE_CTA_LEADFORM_END);
            ctaFormSubComponents.put(name, detail);
            orderedMapForComponents.put(componentCounter++, name);
            Map<String, Object> properties = new HashMap<String, Object>();
            PageComponent formEndComponent = pageBuilder.createComponent(RESOURCE_TYPE_CTA_LEADFORM_END, new ValueMapDecorator(properties),
                ctaFormSubComponents.get(FORM_END).getHintName());
            parsys.getChildComponents().add(formEndComponent);

            pageComponents = new ArrayList<PageComponent>();
            pageComponents.add(parsys);

        } else if (StringUtils.equalsIgnoreCase("label", localName) && this.labelForParameter != null) {
            ComponentDetails detail = ctaFormSubComponents.containsKey(labelForParameter)
                    ? ctaFormSubComponents.get(labelForParameter)
                    : new ComponentDetails(getNameHint(labelForParameter));
            if (labelBuffer != null) detail.getProperties().put(JcrConstants.JCR_TITLE, labelBuffer);
            ctaFormSubComponents.put(labelForParameter, detail);

            // make labelBuffer and labelForParameter as null for further handling
            labelBuffer = null;
            labelForParameter = null;

        }

    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP)
            return true;
        else
            return false;
    }

    private String getNameHint(String componentType) {
        return componentType.toLowerCase() + designImporterContext.componentSuffixGenerator.getSuffix(componentType);
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP) {
            String cqIncludeJspTag = "<sling:include path=" + "\"" + parsysHintName + "\"" + "/>";
            return componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(componentDivStartTag);
        }
        return null;
    }

    public class ComponentDetails {
        private String hintName;

        private Map<String, Object> properties;

        private String resourceType;

        public String getHintName() {
            return hintName;
        }

        public void setHintName(String hintName) {
            this.hintName = hintName;
        }

        public Map<String, Object> getProperties() {
            return properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public ComponentDetails(String hintName) {
            this.hintName = hintName;
            this.properties = new HashMap<String, Object>();
        }

        public String getResourceType() {
            return resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

    }
}
