/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.landingpage.parser.taghandlers.cta;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Constants;

import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;

/**
 *
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = LeadFormCTAComponentTagHandlerFactory.TAG_PATTERN)
})

/**
 * Provides an API to get {@link  LeadFormCTAComponentTagHandler} for supported(div, form) HTML tags for  leadform component.
 */
public class LeadFormCTAComponentTagHandlerFactory implements TagHandlerFactory {

    static public final String TAG_PATTERN = "<(div|form)\\s+.*?data-cq-component=\"(?i)leadformgeneration\".*?>";

    public TagHandler create() {
        return new LeadFormCTAComponentTagHandler();
    }
}
