/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.landingpage.parser.taghandlers.mbox;

import com.day.cq.wcm.designimporter.api.ImporterConstants;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.Constants;
import org.osgi.service.component.ComponentContext;

/**
 *
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = TargetComponentTagHandlerFactory.TAG_PATTERN),
        @Property(name = ImporterConstants.PN_RESOURCE_TYPE, value = TargetComponentTagHandlerFactory.RESOURCE_TYPE_TARGET)

})
public class TargetComponentTagHandlerFactory implements TagHandlerFactory {

    static protected final String RESOURCE_TYPE_TARGET = "cq/personalization/components/target";

    static public final String TAG_PATTERN = "<div\\s+.*?data-cq-component=\"target\".*?>";

    private String resourceType;

    public TagHandler create() {
        TargetComponentTagHandler targetComponentTagHandler = new TargetComponentTagHandler();
        targetComponentTagHandler.setResourcetype(resourceType);
        return targetComponentTagHandler;
    }

    /**
     * The bundle activator method. For internal use.
     * @param context
     */
    @Activate
    protected void activate(ComponentContext context) {
        resourceType = OsgiUtil.toString(context.getProperties().get(ImporterConstants.PN_RESOURCE_TYPE), RESOURCE_TYPE_TARGET);
    }
}
