/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.personalization;

import aQute.bnd.annotation.ProviderType;

/**
 * Simple data object that represents a targeted location item.
 */
@ProviderType
public interface Location {

    /**
     * Returns the name of the location
     * 
     * @return Name of the location
     */
    String getName();

    /**
     * Returns the path to the location
     * 
     * @return Path to the location
     */
    String getPath();

    /**
     * Returns the path to the parent page of the location
     * 
     * @return Path to the parent page of the location
     */
    String getPagePath();
}
