/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2013 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.cq.personalization;

/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;
import java.io.IOException;
import java.util.*;

/**
 * @author platon
 */
@SlingServlet(methods = {"GET"}, resourceTypes = "cq/personalization/touch-ui/datasource/segmentsdatasource")
public class SegmentsDataSourceServlet extends SlingSafeMethodsServlet {

    private static final String SEGMENT_RESOURCE_TYPE = "cq/personalization/components/segmentpage";
    private static final String SEGMENTATION_ROOT = "/etc/segmentation";

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException,
            IOException {
        List<Resource> resourceList = new ArrayList<Resource>();

        ResourceResolver resolver = request.getResourceResolver();
        Resource root = resolver.getResource(SEGMENTATION_ROOT);

        // descent down the campaigns path:
        SegmentsRetriever visitor = new SegmentsRetriever();
        visitor.accept(root);

        List<JSONObject>segments = visitor.getSegments();
        Collections.sort(segments, new SegmentsComparator());
        try {
            for (JSONObject segment: segments) {
                Map segmentEntry = new HashMap();
                segmentEntry.put("value", segment.get("path"));
                segmentEntry.put("text", segment.get("title"));
                ValueMapResource vmRes = new ValueMapResource(resolver, new org.apache.sling.api.resource
                        .ResourceMetadata(), "", new ValueMapDecorator(segmentEntry));
                resourceList.add(vmRes);
            }
        } catch (JSONException e) {
            log.error(e.getMessage(), e);
        }
        request.setAttribute(DataSource.class.getName(), new SimpleDataSource(resourceList.iterator()));

    }


    class SegmentsRetriever extends AbstractResourceVisitor {

        private List<JSONObject> segments = new ArrayList<JSONObject>();

        @Override
        protected void visit(Resource resource) {
            if (SEGMENT_RESOURCE_TYPE.equals(resource.getResourceType())) {
                Resource parentPage = resource.getParent();
                ValueMap vm = resource.adaptTo(ValueMap.class);
                JSONObject object = new JSONObject();
                String title = vm.get("jcr:title", "") + (hasTargetTrait(resource) ?
                        " (from Adobe Target)" :
                        "");
                try {
                    object.put("title", title);
                    object.put("name", parentPage.getName());
                    object.put("path", parentPage.getPath());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                segments.add(object);
            }
        }

        private boolean hasTargetTrait(Resource res) {

            if ("cq/personalization/components/traits/tandt".equals(res.getResourceType())) {
                return true;
            } else {

                for (Iterator<Resource> resourceIterator = res.listChildren(); resourceIterator.hasNext(); ) {
                    Resource currentResource = resourceIterator.next();
                    return hasTargetTrait(currentResource);
                }
                return false;
            }
        }

        public List<JSONObject> getSegments() {
            return segments;
        }
    }

    class SegmentsComparator implements Comparator<JSONObject> {

        public int compare(JSONObject o1, JSONObject o2) {
            if (!(o1.has("title") && o2.has("title"))) {
                return -1;
            }
            try {
                String o1Title = (String) o1.get("title");
                String o2Title = (String) o2.get("title");
                return o1Title.compareTo(o2Title);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            return -1;
        }
    }

}
