/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.personalization;

import aQute.bnd.annotation.ConsumerType;

/**
 * The <code>TargetResourceTypeProvider</code> allows implementing classes to register a resource type
 * to be used instead of the default targeting resource type.  The default resource type is
 * <code>personalization/components/target</code> which provides the default AEM targeting behavior
 * however if custom behavior is required, implementing classes can register a resource type that support
 * their targeting specific requirements.
 *
 * Classes that implement the <code>TargetResourceTypeProvider</code> register their service with a property name
 * of <code>TargetResourceTypeProvider.PROP_RESOURCE_PROVIDER</code> and a value of their specific resource type.
 *
 * <code>@Property(name = TargetResourceTypeProvider.PROP_RESOURCE_PROVIDER, value = MyCustomTargetResourceTypeProvider.RESOURCE_TYPE)</code>
 */
@ConsumerType
public interface TargetResourceTypeProvider {

    /**
     * The name of the service registration property indicating the name of
     * the operation provided by the operation implementation. The value of this
     * service property must be a single String.
     */
    String PROP_RESOURCE_PROVIDER = "cq.personalization.target.resourcetype";

    /**
     * Return the resource type associated with the provider.
     * @return the resource type.
     */
    String getResourceType();

}