/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.personalization;

import aQute.bnd.annotation.ProviderType;

/**
 * Contains the data of a tag associated with a teaser
 */
@ProviderType
public interface TeaserTag {
    /**
     * Returns the name of the tag.
     * @return a {@link String} representing the name of tag
     */
    String getName();

    /**
     * Returns the title of the tag.
     * @return a {@link String} representing the title
     */
    String getTitle();

    /**
     * Returns the title path of the tag. This title path contains namespacing and path information of the tag
     * (e.g. mysite:apparel/hat)
     * @return a {@link String} representing the title path
     */
    String getTitlePath();

    /**
     * Returns the path of the tag from the repository. If this tag is not in the repository this method should return <code>null</code>
     * @return a {@link String} representing the path
     */
    String getPath();

    /**
     * Returns the unique ID of the tag
     * @return a {@link String} representing the id
     */
    String getTagId();
}
