/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.personalization;

import com.adobe.granite.security.user.UserProperties;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.RepositoryException;
import java.lang.reflect.Method;

/**
 * <code>UserPropertiesUtil</code>...
 */
public class UserPropertiesUtil {

    private static final Logger log = LoggerFactory.getLogger(UserPropertiesUtil.class);

    public static boolean isAnonymous(UserProperties userProperties) {
        return userProperties == null || userProperties.getAuthorizableID().equals("anonymous");
    }

    public static boolean isAnonymous(final SlingHttpServletRequest request) {
        final UserProperties userProperties = request.adaptTo(UserProperties.class);
        return isAnonymous(userProperties);
    }

    public static String getValue(UserProperties userProperties, String propertyName) {

        // get object value using reflection
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = UserProperties.class.getMethod(getterName);
            Object valueObject = method.invoke(userProperties, (Object[]) null);
            return valueObject != null ? valueObject.toString() : "";
        } catch (Exception e) {
            log.debug("getValue: error getting value via reflection: ", e);
        }

        try {
            return userProperties.getProperty(propertyName);
        } catch (RepositoryException e) {
            log.error("getValue: error getting value from user properties: ", e);
        }

        return null;
    }
}
