/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.personalization.dto;

import aQute.bnd.annotation.ProviderType;

/**
 * Simple data object that represents a targeted location item.
 * @deprecated
 */
@Deprecated
@ProviderType
public class LocationItem {

    private String name;
    private String path;
    private String page;

    /**
     * Constructs an object of this type, using the name of the location
     * 
     * @param name the name of the location
     */
    public LocationItem(String name) {
        this.name = name;
    }

    /**
     * Sets the path of this location
     * 
     * @param path the path of the location
     * @return a reference to this object
     */
    public LocationItem withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Sets the parent page of this location
     * 
     * @param parentPage the path to the page that contains this targeted location
     * @return a reference to this object
     */
    public LocationItem withParentPage(String parentPage) {
        this.page = parentPage;
        return this;
    }

    /**
     * Returns the name of the location
     * 
     * @return Name of the location
     */
    public String getName() {
        return name;
    }

    /**
     * Returns the path to the location
     * 
     * @return Path to the location
     */
    public String getPath() {
        return path;
    }

    /**
     * Returns the path to the parent page of the location
     * 
     * @return Path to the parent page of the location
     */
    public String getPage() {
        return page;
    }

}
