/*
 * ***********************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 * ***********************************************************************
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.ClientContextUtil;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

public class StorePropertyTag extends TagSupport {

    private static final long serialVersionUID = 4646561799994266940L;

    private String propertyName;
    private String store;
    private String prefix;
    private String suffix;
    private String defaultValue = "";

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        prefix = "";
        suffix = "";
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public int doEndTag() throws JspException {
        final JspWriter out = pageContext.getOut();
        final SlingHttpServletRequest request = TagUtil.getRequest(pageContext);
        try {
            out.println(getScript(request));

        } catch (IOException e) {
            throw new JspException("Could not write script for context profile property", e);
        }

        return EVAL_PAGE;
    }

    String getScript(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);

        StringBuilder res = new StringBuilder();

        String prefixId = ClientContextUtil.getId(request.getResource().getPath());
        String filteredPropertyName = ClientContextUtil.getId(propertyName);
        String id = prefixId + "-" + store + "-" + filteredPropertyName;
        res.append("<div");
        res.append(" id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\"");
        res.append(" class=\"").append(xssAPI.encodeForHTMLAttr("cq-cc-" + store))
                .append(" ").append(xssAPI.encodeForHTMLAttr("cq-cc-" + store + "-" + propertyName))
                .append("\"");
        res.append(" title=\"").append(xssAPI.encodeForHTMLAttr("/" + store + "/" + propertyName)).append("\"");
        res.append(" data-store=\"").append(xssAPI.encodeForHTMLAttr(store)).append("\"");
        res.append(" data-property=\"").append(xssAPI.encodeForHTMLAttr(propertyName)).append("\"");
        res.append(">");
        res.append("</div>");

        res.append("<script type=\"text/javascript\">\n");
        res.append("if( window.CQ_Analytics ) {");
        res.append("CQ_Analytics.ClientContextUtils.renderStoreProperty(");
        res.append("'").append(xssAPI.encodeForJSString(id)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(store)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(propertyName)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(prefix)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(suffix)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(defaultValue)).append("'");
        res.append(");");
        res.append("}");
        res.append("</script>");

        return res.toString();
    }
}
