/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.polling.importer;

import java.util.Iterator;

import aQute.bnd.annotation.ProviderType;

@ProviderType
public interface PollingImporter {

    /**
     * The name of the polling importer service. This may be used to retrieve
     * the service from the service registry.
     */
    public static final String SERVICE_NAME = "com.day.cq.polling.importer.PollingImporter";

    /**
     * Returns an <code>Iterator</code> of all poll configurations registered in
     * the repository. If none are registered, this method returns an empty
     * iterator.
     */
    Iterator<PollConfig> getPollConfigs();

    /**
     * Returns the configured global minimum interval at which poll configs may run.
     *
     * @return The <code>long</code> representing the number of seconds of the interval.
     */
    long getMinimumInterval();
}
