/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.Session;

/**
 * The AggregateHandler is used to determine if a node is an aggregate root or not. Aggregates are used to build
 * replication content and to determine the set of replicated "documents".
 *
 * It is also used the prepare and process the set of aggregates during a replication.
 *
 * @since 5.5
 */
public interface AggregateHandler {

    /**
     * Checks if the given node is an aggregate root.
     * @param node node to test
     * @return <code>true</code> if the node is an aggregate root
     */
    boolean isAggregateRoot(Node node);

    /**
     * Returns a list of aggregate roots of the subtree starting at the specified path that are relevant for the
     * given replication action. The specified start path should be included in the list in any case.
     *
     * @param session session to use for traversal
     * @param type replication action type
     * @param path start path
     * @return a list of aggregate roots.
     * @throws ReplicationException to abort the replication in the preparation stage
     */
    List<String> prepareForReplication(Session session, ReplicationActionType type, String path) throws ReplicationException;
    
    /**
     * Processes the aggregate addressed by the replication action. The aggregate handler may or may not save the changes.
     * @param session the session to use to process the content
     * @param action the replication action
     * @throws ReplicationException to abort the replication in the preparation stage
     */
    void processForReplication(Session session, ReplicationAction action) throws ReplicationException;
}