/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.replication;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

import aQute.bnd.annotation.ProviderType;

/**
 * The replication content filter chain is passed to content builders
 * to support filtering of content during replication.
 *
 * The chain uses all available filters and queries them one after
 * the other.
 *
 * @since 5.14
 */
@ProviderType
public interface ReplicationContentFilterChain {

    /**
     * Chain accepting all operations
     */
    ReplicationContentFilterChain ALLOW_ALL = new ReplicationContentFilterChain() {

        public boolean allowDescent(Node node) throws RepositoryException {
            return true;
        }

        public boolean accept(Property property) throws RepositoryException {
            return true;
        }

        public boolean accept(Node node) throws RepositoryException {
            return true;
        }
    };

    /**
     * Indicates whether all available {@link com.day.cq.replication.ReplicationContentFilter}s accept the given
     * node for inclusion in the replication content.
     *
     * @param node    The {@link javax.jcr.Node} to check.
     * @return <code>true</code> if the node is accepted by every available filter.
     * @throws RepositoryException thrown in case of failure
     */
    boolean accept(final Node node)
    throws RepositoryException;

    /**
     * Indicates whether all of the available {@link com.day.cq.replication.ReplicationContentFilter}s accept the given
     * property for inclusion in the replication content.
     *
     * @param property The {@link javax.jcr.Property} to check.
     * @return <code>true</code> if the node is accepted by every available filter.
     * @throws RepositoryException thrown in case of failure
     */
    boolean accept(final Property property)
    throws RepositoryException;

    /**
     * Indicates whether all of the available {@link com.day.cq.replication.ReplicationContentFilter}s accept the given
     * node for recursion into its children.
     *
     * @param node    The {@link javax.jcr.Node} to check.
     * @return <code>true</code> if the node is accepted by traversal into its children.
     * @throws RepositoryException thrown in case of failure
     */
    boolean allowDescent(final Node node)
    throws RepositoryException;
}