/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.replication;

/**
 * A <code>ReplicationContentFilterFactory</code> creates a new {@link ReplicationContentFilter}s
 * based on a given {@link ReplicationAction}. Each {@link ContentBuilder} gets the filter chain
 * as a {@link ReplicationContentFilterChain} set as a parameter with the name
 * {@link ContentBuilder#PARAMETER_CONTENT_FILER_CHAIN}.
 * The {@link ContentBuilder} involved in creating the replication
 * content is using the chain in order to filter content prior to inclusion into the
 * replication content.
 * <p>
 * Implementations of this interface must register themselves as an OSGi service
 * in order to be picked up for building the filter list.
 */
public interface ReplicationContentFilterFactory {

    /**
     * Creates a new {@link ReplicationContentFilter} specific to the given {@link ReplicationAction}.
     *
     * @param action The {@link ReplicationAction} to consider.
     *
     * @return A {@link ReplicationContentFilter} or <code>null</code> if no filter is provided for the given {@link
     *         ReplicationAction}.
     */
    ReplicationContentFilter createFilter(ReplicationAction action);
}
