/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

/**
 * This exception is thrown by a transport handler when the underlying
 * transport (e.g. HTTP) received an unexpected answer from the remote
 * peer.
 */
public class TransportException extends ReplicationException {

    private static final long serialVersionUID = -2229496808305406859L;

    /**
     * Replication result.
     */
    private ReplicationResult result;

    /**
     * Create a new instance of this class.
     *
     * @param code
     *            error code
     * @param message
     *            error message
     */
    public TransportException(int code, String message) {
        super(message);

        result = new ReplicationResult(false, code, message);
    }

    /**
     * Return the replication result.
     *
     * @return replication result
     */
    public ReplicationResult getResult() {
        return result;
    }
}
