/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import java.util.Locale;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/**
 * This interface represents {@link Data} that is pepared for being used in charts.
 */
public interface ChartData {

    /**
     * Writes the chart data to the specified {@link JSONWriter}.
     *
     * @param writer The JSON writer
     * @param locale The locale to be used for formatting data
     * @throws JSONException if an error occured while creating the JSON
     */
    public abstract void writeDataJSON(JSONWriter writer, Locale locale)
            throws JSONException;

}
