package com.day.cq.reporting;

/**
 * This interface provides means to provide components to a report (such as value
 * resolvers, aggregates, etc.).
 */
public interface ComponentProvider {

    /**
     * <p>Acquires a {@link ValueResolver} for the specified resolver ID.</p>
     *
     * <p>The resolver instance must be explicitly released using
     * {@link #releaseValueResolver(ValueResolver)}.</p>
     *
     * @param resolverId The resolver ID
     * @return The corresponding {@link ValueResolver}; <code>null</code> if the resolver
     *         could not be instantiated
     */
    ValueResolver acquireValueResolver(String resolverId);

    /**
     * Releases the specified {@link ValueResolver}.
     *
     * @param resolver The resolver to release
     */
    void releaseValueResolver(ValueResolver resolver);

    /**
     * <p>Acquires an {@link Aggregate} for the specified aggregate ID.</p>
     *
     * <p>The aggregate must be explicitly released using
     * {@link #releaseAggregate(Aggregate)}.</p>
     *
     * @param aggregateId The aggregate ID
     * @return The corresponding {@link Aggregate}; <code>null</code> if the aggregate
     *         could not be instantiated
     */
    Aggregate acquireAggregate(String aggregateId);

    /**
     * Releases the specified {@link Aggregate}.
     *
     * @param aggregate The aggregate to release
     */
    void releaseAggregate(Aggregate aggregate);

    /**
     * <p>Acquires a {@link ValueExtractor} for the specified extractor ID.</p>
     *
     * <p>The extractor must be explicitly released using
     * {@link #releaseExtractor(ValueExtractor)}.</p>
     *
     * @param extractorId The extractor ID
     * @return The corresponding {@link ValueExtractor}; <code>null</code> if the extractor
     *         could not be instantiated
     */
    ValueExtractor acquireValueExtractor(String extractorId);

    /**
     * Releases the specified {@link ValueExtractor}.
     *
     * @param extractor The extractor to release
     */
    void releaseExtractor(ValueExtractor extractor);

    /**
     * <p>Acquires a {@link Filter} for the specified filter ID.</p>
     *
     * <p>The filter must be explicitly released using {@link #releaseFilter(Filter)}.</p>
     *
     * @param filterId The filter ID
     * @return The corresponding {@link Filter}; <code>null</code> if the filter
     *         could not be instantiated
     */
    Filter acquireFilter(String filterId);

    /**
     * Releases the specified {@link Filter}.
     *
     * @param filter The filter to release
     */
    void releaseFilter(Filter filter);

}
