/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import javax.jcr.RepositoryException;
import java.util.Iterator;

/**
 * This interface represents a report (for serverside calculation) as a whole.
 */
public interface Report {

    /**
     * Creates the report and returns the data as a result.
     *
     * @return The report's data
     * @throws RepositoryException if calculating data fails due to a repository error
     */
    Data calculate() throws RepositoryException;

    /**
     * Creates an iterator for iterating over the report's columns.
     *
     * @return Column iterator
     */
    Iterator<Column> getColumnIterator();

    /**
     * Returns the number of columns.
     *
     * @return Number of columns
     */
    int getColumnCnt();

    /**
     * Returns if any group is grouped.
     *
     * @return <code>true</code> if any column is grouped
     */
    boolean hasGroupedColumns();

    /**
     * Creates an iterator for iterating over the columns to be used for snapshot data.
     *
     * @return Snapshot column iterator
     */
    Iterator<Column> getSnapshotDataCols();

    /**
     * Gets the root path of this report (for querying the data).
     *
     * @return Root path of this report; <code>null</code> if no root path is specified
     *         for the report
     */
    String getDataRoot();

    /**
     * Cleans up the report after using it.
     */
    void cleanup();

}
