/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import javax.jcr.Session;

/**
 * This interface represents services that are responsible for creating data snapshots of
 * all registered snapshots at a scheduled time and on a regular base.
 */
public interface SnapshotService {

    /**
     * Takes a snapshot of currently scheduled reports
     *
     * @param type Type of snapshot to be taken
     */
    void executeSnapshot(SnapshotType type);

    /**
     * Takes a snapshot of the report at the specified path immediately.
     *
     * @param session The {@link Session} to be used for reading the report definition and
     *                writing the snapshot data; gathering report data is executed through
     *                another {@link Session} that has usually less permissions
     * @param path The report's path
     */
    void takeSnapshot(Session session, String path);

}
