/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This enumerations defines the snapshot types available.
 */
public enum SnapshotType {

    /**
     * No snapshot
     */
    NEVER("never"),

    /**
     * Hourly snapshots
     */
    HOURLY("hourly"),

    /**
     * Daily snapshots
     */
    DAILY("daily"),

    /**
     * Forced snapshot
     */
    FORCED("forced");


    /**
     * The string representation of the snapshot type
     */
    private final String stringRep;


    /**
     * Creates a new snapshot type.
     *
     * @param stringRep The string representation of the snapshot type
     */
    private SnapshotType(String stringRep) {
        this.stringRep = stringRep;
    }

    /**
     * Gets the string representation of the snapshot type.
     *
     * @return The string representation of the snapshot type
     */
    public String getStringRep() {
        return this.stringRep;
    }

    /**
     * Creates a suitable <code>SnapshotType</code> from the specified string
     * representation.
     *
     * @param stringRep The string representation
     * @return The snapshot type; <code>null</code> if an invalid string representation
     *         has been specified
     */
    public static SnapshotType fromStringRep(String stringRep) {
        SnapshotType[] types = values();
        for (SnapshotType type : types) {
            if (type.getStringRep().equals(stringRep)) {
                return type;
            }
        }
        return null;
    }

}
