/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.search.eval;

import javax.jcr.query.Row;

import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.collection.ResourceCollection;

import com.day.cq.search.Predicate;

/**
 * <code>CollectionPredicateEvaluator</code> restricts the result to a members of a sling collection.
 * <p/>
 * <h3>Name:</h3> memberOf
 * <p/>
 * <h3>Properties:</h3>
 * <dl>
 * <dt>memberOf</dt>
 * <dd>path of sling collection;</dd>
 * <dl>

 * @since 6.0
 */
@Component(metatype = false, factory = "com.day.cq.search.eval.PredicateEvaluator/memberOf")
public class CollectionPredicateEvaluator extends AbstractPredicateEvaluator {
    public static final String COLLECTION = "memberOf";


    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(COLLECTION)) {
            return true;
        }
        Resource colRes = context.getResourceResolver().getResource(p.get(COLLECTION));
        if (colRes != null) {
            ResourceCollection collection = colRes.adaptTo(ResourceCollection.class);

            final Resource resource = context.getResource(row);
            return collection.contains(resource);
        }

        //return false if the collection does not exist now.
        return false;
    }



    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return false;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }

}
