/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import org.apache.felix.scr.annotations.Component;


/**
 * <code>FulltextPredicateEvaluator</code> searches for a term in the fulltext index.
 *
 * <p>
 * <b>Note:</b> Does not implement filtering, which means this predicate
 * cannot be used together with filter-only predicates in an OR group.
 *
 * <h3>Name:</h3>
 * fulltext
 *
 * <h3>Properties:</h3>
 * <dl>
 * <dt>fulltext</dt><dd>the fulltext search term</dd>
 * <dt>relPath</dt><dd>the relative path to search in (eg. property or subnode) (optional)</dd>
 * <dl>
 *
 * @since 5.2
 */
@Component(metatype = false, factory="com.day.cq.search.eval.PredicateEvaluator/fulltext")
public class FulltextPredicateEvaluator extends AbstractPredicateEvaluator {

    public static final String FULLTEXT = "fulltext";
    public static final String REL_PATH = "relPath";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue(FULLTEXT)) {
            return null;
        }
        
        return XPath.JCR_CONTAINS + "(" + p.get(REL_PATH, ".") + ", " + XPath.getFulltextStringLiteral(p.get(FULLTEXT)) + ")";
    }

    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return true;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return false;
    }
}
