/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.facets.extractors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.day.cq.search.facets.Bucket;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.facets.FacetExtractor;

/**
 * <code>FacetImpl</code> is a simple implementation of the {@link Facet}
 * interface, which basically holds a collection of {@link Bucket Buckets}.
 * 
 * <p>
 * Note that this class resides in a public package (OSGi) for easy reuse of
 * custom {@link FacetExtractor FacetExtractors}.
 * 
 * @since 5.2
 */
public class FacetImpl implements Facet {
    
    private List<Bucket> buckets = new ArrayList<Bucket>();

    /**
     * Creates a facet without any buckets. Use {@link #addBucket(Bucket)} to
     * add buckets one by one.
     */
    public FacetImpl() {
    }

    /**
     * Creates a facet with a given list of buckets.
     */
    public FacetImpl(Collection<? extends Bucket> buckets) {
        this.buckets.addAll(buckets);
    }

    /**
     * Adds a bucket to the list of buckets that will be returned in
     * {@link #getBuckets()}.
     */
    public void addBucket(Bucket bucket) {
        this.buckets.add(bucket);
    }
    
    // -------------------------------------------------------< Facet interface >

    public List<Bucket> getBuckets() {
        return buckets;
    }

    public boolean getContainsHit() {
        for (Bucket bucket : getBuckets()) {
            if (bucket.getCount() > 0) {
                return true;
            }
        }
        return false;
    }

}
