package com.day.cq.searchpromote;

/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * Various constants used throughout the integration
 */
public interface SearchPromoteConstants {

    /**
     * property of /etc/commerce/searchpromote/feed/deleted
     * marks that the deleted feed has been consumed by S&amp;P
     */
    public static final String PN_FEED_CONSUMED = "feed_consumed";

    /**
     * property of /etc/commerce/searchpromote/feed/deleted
     * marks that the deleted feed has been consumed by S&amp;P
     */
    public static final String PN_DELETED_SKUS = "skus";

    /**
     * Http Client timeout in milliseconds until a connection is established. A
     * timeout value of 0 is interpreted as an infinite timeout.
     */
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;

    /**
     * Http Client timeout in milliseconds, which is the timeout for waiting for
     * data or a maximum period of inactivity between two consecutive data
     * packets. A timeout value of 0 is interpreted as an infinite timeout.
     */
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;

}
