/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote;

import com.day.cq.searchpromote.impl.SearchPromoteEnvironment;

import aQute.bnd.annotation.ProviderType;

import java.net.URI;

@ProviderType
public interface SearchPromoteService {

    /**
     * Returns configured Search&amp;Promote server where configurations are fetched
     * from.
     * 
     * @return URI for Search&amp;Promote server
     */
    URI getServerURI();

    /**
     * Returns an XML string representation for search form from the stage environment of Search&amp;Promote.
     * 
     * @param memberid
     *            Member ID
     * @param accountnumber
     *            Account number
     * @return String representation of the search form XML
     * @throws SearchPromoteException {@link SearchPromoteException}
     *             if XML could not be fetched or response is invalid.
     */
    String getSearchForm(String memberid, String accountnumber) throws SearchPromoteException;

    /**
     * Returns an XML string representation for search form. The search form is retrieved from the specified environment
     * @param memberId
     *          Member ID
     * @param accountNumber
     *          Account number
     * @param environment
     *          The Search&amp;Promote environment (stage / live)
     * @return String representation of the search form XML
     * @throws SearchPromoteException {@link SearchPromoteException}
     */
    String getSearchForm(String memberId, String accountNumber, SearchPromoteEnvironment environment) throws SearchPromoteException;
    
    /**
     * Returns a JSON string representation of available Facets.
     * 
     * @param memberid
     *            Member ID
     * @param accountnumber
     *            Account number
     * @return JSON string representation of the available Facets
     * @throws SearchPromoteException {@link SearchPromoteException}
     *             if JSON could not be feteched or response is invalid.
     */
    String getFacetList(String memberid, String accountnumber) throws SearchPromoteException;
    
    /**
     * Returns a JSON string representation of available BannerAreas.
     * 
     * @param memberid
     *            Member ID
     * @param accountnumber
     *            Account number
     * @return JSON string representation of the available BannerAreas
     * @throws SearchPromoteException {@link SearchPromoteException}
     *             if JSON could not be feteched or response is invalid.
     */
    String getBannerAreaList(String memberid, String accountnumber) throws SearchPromoteException;

    /**
     * Calls the remote indexer
     * @param accountNumber Account number
     * @param remotePassword The remote indexer password
     * @param fullIndex signals that a full feed index is requested
     * @return a {@link String} representing the request's outcome.
     *  Possible values are <code>OK</code> if the request was sent successfully, <code>Error</code> otherwise.
     * @throws SearchPromoteException {@link SearchPromoteException}
     */
    String callRemoteIndex(String accountNumber, String remotePassword, boolean fullIndex) throws SearchPromoteException;

    /**
     * Returns the configured timeout in milliseconds until a connection is
     * established. A timeout value of 0 is interpreted as an infinite
     * timeout.
     * 
     * @return Timeout in milliseconds. If value is not configured
     *         {@link SearchPromoteConstants#DEFAULT_CONNECTION_TIMEOUT} is
     *         returned.
     */
    int getConnectionTimeout();

    /**
     * Returns the configured timeout in milliseconds, which is the timeout for
     * waiting for data or a maximum period of inactivity between two
     * consecutive data packets. A timeout value of 0 is interpreted as an infinite
     * timeout.
     * 
     * @return Timeout in milliseconds. If value is not configured
     *         {@link SearchPromoteConstants#DEFAULT_SOCKET_TIMEOUT} is
     *         returned.
     */
    int getSocketTimeout();

}
