/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import com.day.cq.searchpromote.SearchPromoteException;

public class DOMParser {

	public Element parseXML(InputSource xml) throws SearchPromoteException {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            // XXE protection
            // see https://www.owasp.org/index.php/XML_External_Entity_(XXE)_Processing
            String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            factory.setFeature(FEATURE, true);

			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(xml);
			return document.getDocumentElement();
		} catch (ParserConfigurationException e) {
			throw new SearchPromoteException("Unable to create XML parser", e);
		} catch (SAXParseException e) {
			throw new SearchPromoteException("XML syntax error. (Line: " + e.getLineNumber() + " Column: " + e.getColumnNumber() + ")", e);
		} catch (SAXException e) {
			throw new SearchPromoteException("XML syntax error. ", e);
		} catch (IOException e) {
			throw new SearchPromoteException("XML could not be read.", e);
		}
	}

    protected Element getElement(Element parent, String name, boolean required) throws SearchPromoteException {
        NodeList children = parent.getChildNodes();
        Element found = null;
        for (int i = 0; i < children.getLength(); i++) {
            Node child = children.item(i);
            if (child.getNodeType() == Node.ELEMENT_NODE
                    && name.equals(child.getNodeName())) {
                if (found != null) {
                    throw new SearchPromoteException( "Duplicate configuration element " + name + " in " + parent.getNodeName() + ".");
                }
                found = (Element) child;
            }
        }
        if (required && found == null) {
            throw new SearchPromoteException("Configuration element " + name + " not found in " + parent.getNodeName() + ".");
        }
        return found;
    }

    protected String getAttribute(Element element, String name) throws SearchPromoteException {
        Attr attribute = element.getAttributeNode(name);
        if (attribute != null) {
            return attribute.getValue();
        } else {
            throw new SearchPromoteException("Configuration attribute " + name + " not found in " + element.getNodeName() + ".");
        }
    }

}
