/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.form;

import org.apache.sling.api.SlingHttpServletRequest;

import com.day.cq.searchpromote.Search;

public class SearchForm {
    
    private SlingHttpServletRequest request;
    
    private AutoComplete autocomplete;
    
    private Tnt tnt;
    
    private Form form;
    
    private String action;
    
    public SearchForm(SlingHttpServletRequest request, AutoComplete autocomplete, Tnt tnt, Form form) {
        this.request = request;
        this.autocomplete = autocomplete;
        this.tnt = tnt;
        this.form = form;
    }
    
    public SearchForm(AutoComplete autocomplete, Tnt tnt, Form form) {
        this(null, autocomplete, tnt, form);
    }
    
    /**
     * Get {@link SlingHttpServletRequest}
     * 
     * @return {@link SlingHttpServletRequest}
     */
    public SlingHttpServletRequest getRequest() {
        return request;
    }
    
    /**
     * Set {@link SlingHttpServletRequest}
     * 
     * @param request {@link SlingHttpServletRequest}
     */
    public void setRequest(SlingHttpServletRequest request) {
        this.request = request;
    }
    
    /**
     * Returns the form action attribute.
     * 
     * @return form action attribute
     */
    public String getAction() {
        return action;
    }
    
    /**
     * Sets the form action attribute.
     * 
     * @param action form action attribute
     */
    public void setAction(String action) {
        this.action = action;
    }

    /**
     * Returns {@link AutoComplete} element.
     * 
     * @return AutoComplete or <code>null</code> if element is missing
     */
    public AutoComplete getAutocomplete() {
        return autocomplete;
    }
    
    /**
     * Returns {@link Tnt} element.
     * 
     * @return Tnt or <code>null</code> if element is missing
     */
    public Tnt getTnt() {
        return tnt;
    }
    
    /**
     * Returns {@link Form} element.
     * 
     * @return Form
     */
    public Form getForm() {
        return form;
    }
    
    /**
     * Prints out the form tag with contained input fields and the DIV elements
     * for auto-completion and Adobe Target integration.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<form method=\"GET\"");
        if(form.getId() != null) {
            sb.append(" id=\"" + form.getId() + "\"");
        }
        if(form.getName() != null) {
            sb.append(" name=\"" + form.getName() + "\"");
        }
        sb.append(" action=\"" + ((action != null) ? action : form.getAction()) + "\"");
        sb.append(">\n");
        for(Input input : form.getInputs()) {
            sb.append(input.toString() + "\n");
        }
        if(autocomplete != null && autocomplete.getEnabled() && 
                autocomplete.getFormContent() != null) {
            sb.append(autocomplete.getFormContent());
        }
        if(tnt != null && tnt.getEnabled() && 
                tnt.getFormContent() != null) {
            sb.append(tnt.getFormContent());
        }
        sb.append("</form>");
        return sb.toString();
    }
    
}
