/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.form;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import com.day.cq.searchpromote.SearchPromoteException;
import com.day.cq.searchpromote.xml.DOMParser;

public class SearchFormParser extends DOMParser {
    
    private static final String AUTOCOMPLETE_ELEMENT = "autocomplete";

    private static final String TNT_ELEMENT = "tnt";
    
    private static final String FORM_ELEMENT = "form";
    
    private static final String CSS_ELEMENT = "css";
    
    private static final String ENABLED_ELEMENT = "enabled";
    
    private static final String JAVASCRIPT_ELEMENT = "javascript";
    
    private static final String FORMCONTENT_ELEMENT = "form-content";
    
    private static final String NAME_ELEMENT = "name";
    
    private static final String ID_ELEMENT = "id";
    
    private static final String ACTION_ELEMENT = "action";
    
    private static final String TYPE_ELEMENT = "type";
    
    private static final String VALUE_ELEMENT = "value";
    
    private static final String INPUTS_ELEMENT = "inputs";
    
    public SearchFormParser() {
        
    }
    
    public SearchForm parse(InputSource xml) throws SearchPromoteException {
        Element root = parseXML(xml);
        
        Element autocompleteElement = getElement(root, AUTOCOMPLETE_ELEMENT, false);
        AutoComplete autocomplete =  (autocompleteElement != null) ? parseAutocomplete(autocompleteElement) : null;
        
        Element tntElement = getElement(root, TNT_ELEMENT, false);
        Tnt tnt = (tntElement != null) ? parseTnt(tntElement) : null;
        
        Element formElement = getElement(root, FORM_ELEMENT, true);
        Form form = parseForm(formElement);
        
        return new SearchForm(autocomplete, tnt, form);
    }
    
    protected AutoComplete parseAutocomplete(Element element) throws SearchPromoteException {
        Boolean isEnabled = getEnabled(element);
        String formContent = getElement(element, FORMCONTENT_ELEMENT, true).getTextContent();
        String javaScript = getElement(element, JAVASCRIPT_ELEMENT, true).getTextContent();        
        String css = getElement(element, CSS_ELEMENT, true).getTextContent();
        
        return new AutoComplete(isEnabled,formContent,javaScript,css);
    }
    
    protected Tnt parseTnt(Element element) throws SearchPromoteException {
        Boolean isEnabled = getEnabled(element);
        String formContent = getElement(element, FORMCONTENT_ELEMENT, true).getTextContent();
        String javaScript = getElement(element, JAVASCRIPT_ELEMENT, true).getTextContent();    
        
        return new Tnt(isEnabled, formContent, javaScript);
    }
    
    protected Form parseForm(Element element) throws SearchPromoteException {
        String name = getElement(element, NAME_ELEMENT, true).getTextContent();
        String id = getElement(element, ID_ELEMENT, true).getTextContent();
        String action = getElement(element, ACTION_ELEMENT, true).getTextContent();
        Element inputs = getElement(element, INPUTS_ELEMENT, false);
        List<Input> input = parseInputs(inputs);
        
        return new Form(name, id, action, input);
    }
    
    protected List<Input> parseInputs(Element element) throws SearchPromoteException {
        List<Input> inputs = new ArrayList<Input>();
        NodeList list = element.getChildNodes();
        for(int i=0; i<list.getLength(); i++) {
            Node n = list.item(i);
            if(n.getNodeType() == Node.ELEMENT_NODE){
                String type = getElement((Element) n, TYPE_ELEMENT, true).getTextContent();                
                Element valueEl = getElement((Element) n, VALUE_ELEMENT, false);
                String value = (valueEl != null) ? valueEl.getTextContent() : null;                
                Element idEl = getElement((Element) n, ID_ELEMENT, false);
                String id = (idEl != null) ? idEl.getTextContent() : null;
                Element nameEl = getElement((Element) n, NAME_ELEMENT, false);
                String name = (nameEl != null) ? nameEl.getTextContent() : null;
                inputs.add(new Input(type, id, name, value));
            }
        }
        return inputs;
    }

    private Boolean getEnabled(Element element) throws SearchPromoteException {
        String enabled = getElement(element, ENABLED_ELEMENT, true).getTextContent();    
        Boolean isEnabled = Integer.parseInt(enabled) == 1 ? Boolean.TRUE : Boolean.FALSE;
        return isEnabled;
    }
}
