/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

/**
 * A base class for all the result entities like facets, menus etc.
 */
public abstract class AbstractResultEntity implements ResultEntity {

    /**
     * Reads the data from the provided {@link XMLEventReader}.
     *
     * @param reader the {@link XMLEventReader} to read the data from
     * @return the data read from the reader
     * @throws XMLStreamException if a XML processing error occurs
     */
    protected String readData(XMLEventReader reader) throws XMLStreamException {
        if (reader.peek().isEndElement() || reader.peek().isEndDocument()) {
            return "";
        }
        String data = reader.nextEvent().asCharacters().getData();
        return data.trim();
    }

    @Override
    public abstract void parse(XMLEventReader reader) throws Exception;

}
