/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoComplete extends AbstractResultEntity {
    private static final Logger LOG = LoggerFactory.getLogger(AutoComplete.class);
    private static final String ENABLE_NODE = "enabled";
    private static final String CSS_NODE    = "css";
    private static final String FORM_NODE   = "form-content";
    private static final String JS_NODE     = "javascript";
    
    private String  css;
    private String  formContent;
    private String  js;
    private boolean enabled;
    
    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing auto-complete tag");
        while( reader.hasNext() ) {
            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;
            
            StartElement element = nextEvent.asStartElement();
            String localPart = element.getName().getLocalPart();
            LOG.debug("Found node {}", localPart);
            if( ENABLE_NODE.equals(localPart)) {
                String data = readData(reader);
                enabled = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
            }
            else
            if( CSS_NODE.equals(localPart)) {
                String data = readData(reader);
                css = data;
                ResultParser.getNextEvent(reader);
            }
            else
            if( FORM_NODE.equals(localPart)) {
                String data = reader.nextEvent().asCharacters().getData();
                formContent = data;
                ResultParser.getNextEvent(reader);
            }
            else
            if( JS_NODE.equals(localPart)) {
                String data = reader.nextEvent().asCharacters().getData();
                js = data;
                ResultParser.getNextEvent(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }            
        }
        LOG.debug("Auto-complete node parsed.");
    }

    public String getCss() {
        return css;
    }

    public String getFormContent() {
        return formContent;
    }

    public String getJs() {
        return js;
    }

    public boolean isEnabled() {
        return enabled;
    }
}
