/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadCrumbItem extends AbstractResultEntity {
    private static final String LABEL_NODE = "label";
    private static final String VALUE_NODE = "value";
    private static final String LINK_NODE  = "link";

    private static final Logger LOG = LoggerFactory.getLogger(BreadCrumbItem.class);

    private String label;
    private String value;
    private String queryString;
    
    public void parse(XMLEventReader reader) throws Exception {
        while( reader.hasNext() ) {
            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;
            
            StartElement element = nextEvent.asStartElement();
            
            XMLEvent event = reader.nextEvent();
            if( event.isEndElement())
                continue;

            String localPart =  element.getName().getLocalPart();
            LOG.debug("Found node {}", localPart);
            if( LABEL_NODE.equals(localPart)) {
                label =  event.asCharacters().getData();
                ResultParser.getNextEvent(reader);
            }
            else
            if(VALUE_NODE.equals(localPart)) {
                value =  event.asCharacters().getData();
                ResultParser.getNextEvent(reader);
            }
            else
            if(LINK_NODE.equals(localPart)) {
                queryString = event.asCharacters().getData();
                ResultParser.getNextEvent(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }


    }

    public String getLabel() {
        return label;
    }

    public String getValue() {
        return value;
    }

    public String getQueryString() {
        return queryString;
    }
}
