/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CustomField implements ResultEntity {
    private static final String NAME_NODE = "name";
    
    private String name;
    private String value;
    
    public void parse(XMLEventReader reader) throws Exception {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if( event.isEndElement())
                return;
            
            StartElement startElement = event.asStartElement();
            name = startElement.getAttributeByName(new QName(NAME_NODE)).getValue();
            XMLEvent nextEvent = reader.nextEvent();
            if( nextEvent.isEndElement() ) 
                return;
            
            value = nextEvent.asCharacters().getData();
            ResultParser.getNextEvent(reader);
    }

    public String getName() {
        return name;
    }
    
    public String getValue() {
        return value;
    }
}
