/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.events.StartElement;

public class CustomFieldList implements ResultEntity {
    private static final String CUSTOM_FIELD_NODE = "custom-field";
    private List<CustomField> customFields;
    
    public CustomFieldList() {
        customFields = new ArrayList<CustomField>();
    }
    
    public void parse(XMLEventReader reader) throws Exception {
        while( reader.hasNext()) {
            XMLEvent event;
            while( ( event = reader.peek() ).isCharacters() )
                reader.nextEvent();
            if( event.isEndElement()) {
                ResultParser.getNextEvent(reader);
                break;
            }

            StartElement element = event.asStartElement();
            if( element.getName().getLocalPart().equals(CUSTOM_FIELD_NODE)) {
                CustomField field = new CustomField();
                field.parse(reader);
                customFields.add(field);
            } 
            else {
                ResultParser.getNextEvent(reader);
                ResultParser.parseUnknownTag(reader);
            }
            
        }
    }
    
    public List<CustomField> getCustomFields() {
        return customFields;
    }
}
