/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 * Copyright 2011 Adobe Systems Incorporated
 * All Rights Reserved.
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerResult implements ResultEntity {
    private static final Logger LOG = LoggerFactory.getLogger(CustomerResult.class);

    private static final String QUERY_NODE = "query";

    private static final String CUSTOM_FIELDS_NODE = "custom-fields";

    private static final String MENUS_NODE = "menus";

    private static final String BREADCRUMBS_NODE = "breadcrumbs";

    private static final String SUGGESTIONS_NODE = "suggestions";

    private static final String PAGINATION_NODE = "pagination";

    private static final String FACETS_NODE = "facets";

    private static final String RESULTS_NODE = "results";

    private static final String BANERS_NODE = "banners";

    private static final String ZONES_NODE = "zones";

    private static final String TEMPLATE_NODE = "template";

    private static final String SEARCH_FORM_NODE = "search-form";

    private static final String REDIRECT_NODE = "redirect";

    private Query query;

    private CustomFieldList customFieldList;

    private MenuList menuList;

    private BreadCrumbList breadCrumbList;

    private Suggestions suggestionList;

    private Pagination pagination;

    private FacetList facetList;

    private ResultList resultList;

    private BannerList bannerList;

    private ZoneList zoneList;

    private SearchForm searchForm;

    private Template template;

    private Redirect redirect;

    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing results...");
        while (reader.hasNext()) {
            XMLEvent subElement = ResultParser.getNextEvent(reader);
            if (subElement == null || subElement.isEndElement()) { break; }

            StartElement element = subElement.asStartElement();
            String localPart = element.getName().getLocalPart();
            LOG.debug("Found node {}", localPart);
            if (localPart.equals(QUERY_NODE)) {
                query = new Query();
                query.parse(reader);
            } else if (localPart.equals(CUSTOM_FIELDS_NODE)) {
                customFieldList = new CustomFieldList();
                customFieldList.parse(reader);
            } else if (localPart.equals(MENUS_NODE)) {
                menuList = new MenuList();
                menuList.parse(reader);
            } else if (localPart.equals(BREADCRUMBS_NODE)) {
                breadCrumbList = new BreadCrumbList();
                breadCrumbList.parse(reader);
            } else if (localPart.equals(SUGGESTIONS_NODE)) {
                suggestionList = new Suggestions();
                suggestionList.parse(reader);
            } else if (localPart.equals(PAGINATION_NODE)) {
                pagination = new Pagination();
                pagination.parse(reader);
            } else if (localPart.equals(FACETS_NODE)) {
                facetList = new FacetList();
                facetList.parse(reader);
            } else if (localPart.equals(RESULTS_NODE)) {
                resultList = new ResultList();
                resultList.parse(reader);
            } else if (localPart.equals(BANERS_NODE)) {
                bannerList = new BannerList();
                bannerList.parse(reader);
            } else if (localPart.equals(ZONES_NODE)) {
                zoneList = new ZoneList();
                zoneList.parse(reader);
            } else if (localPart.equals(SEARCH_FORM_NODE)) {
                searchForm = new SearchForm();
                searchForm.parse(reader);
            } else if (localPart.equals(TEMPLATE_NODE)) {
                template = new Template();
                template.parse(reader);
            } else if (localPart.equals(REDIRECT_NODE)) {
                redirect = new Redirect();
                redirect.parse(reader);
            } else {
                ResultParser.parseUnknownTag(reader);
            }
        }
        LOG.debug("Done parsing results.");
    }

    public Query getQuery() {
        return query;
    }

    public CustomFieldList getCustomFieldList() {
        return customFieldList;
    }

    public MenuList getMenuList() {
        return menuList;
    }

    public BreadCrumbList getBreadCrumbList() {
        return breadCrumbList;
    }

    public Suggestions getSuggestions() {
        return suggestionList;
    }

    public Pagination getPagination() {
        return pagination;
    }

    public FacetList getFacetList() {
        return facetList;
    }

    public ResultList getResultList() {
        return resultList;
    }

    public BannerList getBannerList() {
        return bannerList;
    }

    public ZoneList getZoneList() {
        return zoneList;
    }

    public SearchForm getSearchForm() {
        return searchForm;
    }

    public Redirect getRedirect() {
        return redirect;
    }

}
