/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Facet extends AbstractResultEntity {
    private static final Logger LOG = LoggerFactory.getLogger(Facet.class);
    private static final String SELECTED_NODE  = "selected";
    private static final String TITLE_NODE     = "facet-title";
    private static final String UNDO_LINK_NODE = "undo-link";
    private static final String ITEM_NODE      = "facet-value";
    private static final String BEHAVIOR_NODE  = "behavior";
    
    private boolean          selected;
    private String           title;
    private String           undoQueryString;
    private List<FacetValue> items;
    private String             behavior;

    public Facet() {
        items = new ArrayList<FacetValue>();
    }
    
    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing facet...");
        while( reader.hasNext() ) {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if( event.isEndElement())
                break;
            
            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();
            LOG.debug("Parsing node {}", localPart);
            if( localPart.equals(SELECTED_NODE)) {
                selected = ResultParser.strToBool( readData(reader) );
                ResultParser.getNextEvent(reader);
            }
            else
            if( localPart.equals(TITLE_NODE)) {
                title = readData(reader);
                LOG.debug("Facet title is {}", title);
                ResultParser.getNextEvent(reader);
            }
            else
            if( localPart.equals(BEHAVIOR_NODE)) {
                behavior = readData(reader);
                ResultParser.getNextEvent(reader);
            }
            else
            if( localPart.equals(UNDO_LINK_NODE)) {
                undoQueryString = readData(reader);
                ResultParser.getNextEvent(reader);
            }
            else
            if( localPart.equals(ITEM_NODE)) {
                FacetValue item = new FacetValue(  );
                item.parse(reader);
                items.add(item);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
            LOG.debug("Done parsing facet {}", title);
        }
    }

    public boolean isSelected() {
        return selected;
    }

    public String getTitle() {
        return title;
    }

    public String getUndoQueryString() {
        return undoQueryString;
    }
    
    public Boolean hasUndoQueryString() {
        return (undoQueryString != null && !"".equals(undoQueryString));
    }

    public List<FacetValue> getItems() {
        return items;
    }
    
    public String getBehavior() {
        return behavior;
    }
}
