/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.events.StartElement;

public class FacetList implements ResultEntity {
    private static final String FACET_NODE = "facet";
    private List<Facet> facets;
    
    public FacetList() {
        facets = new ArrayList<Facet>();
    }
    
    public void parse(XMLEventReader reader) throws Exception {
        while( reader.hasNext() ) {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if( event.isEndElement())
                break;

            StartElement element = event.asStartElement();
            if( element.getName().getLocalPart().equals(FACET_NODE)) {
                Facet facet = new Facet();
                facet.parse(reader);
                facets.add(facet);            } 
            else {
                ResultParser.parseUnknownTag(reader);
            }            
        } 

    }

    public List<Facet> getFacets() {
        return facets;
    }
}
