/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetValue extends AbstractResultEntity {

    private static final Logger LOG = LoggerFactory.getLogger(FacetValue.class);

    private static final String LABEL_NODE         = "label";
    private static final String COUNT_NODE         = "count";
    private static final String LINK_NODE          = "link";
    private static final String UNDO_LINK_NODE     = "undolink";
    private static final String SELECTED_NODE      = "selected";
    private static final String HAS_CHILDREN_NODE  = "facet-has-children";
    private static final String CHILDREN_NODE      = "children";

    private String  label;
    private String  undoQueryString;
    private String  queryString;
    private Long    count;
    private boolean selected;
    private boolean hasChildren;
    private FacetValueChildList childList;

    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing facet value");
        while( reader.hasNext() ) {
            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;
            
            StartElement element = nextEvent.asStartElement();
            String localPart =  element.getName().getLocalPart();
            LOG.debug("Parsing node {}", localPart);
            if( LABEL_NODE.equals(localPart)) {
                String data = readData(reader) ;
                label = data;
                ResultParser.getNextEvent(reader);
            }
            else
            if( COUNT_NODE.equals(localPart)) {
                String data = readData(reader);
                count = ResultParser.strToLong(data);
                ResultParser.getNextEvent(reader);
            }
            else
            if( LINK_NODE.equals(localPart)) {
                String data = readData(reader);
                queryString = data;
                ResultParser.getNextEvent(reader);
            }
            else
            if( UNDO_LINK_NODE.equals(localPart)) {
                String data = readData(reader);
                undoQueryString = data;
                ResultParser.getNextEvent(reader);
            }
            else
            if( SELECTED_NODE.equals(localPart)) {
                String data = readData(reader);
                selected = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
            }
            else
            if( HAS_CHILDREN_NODE.equals(localPart)) {
                String data = readData(reader);
                hasChildren = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
            }
            else
            if( element.getName().getLocalPart().equals(CHILDREN_NODE)) {
                childList = new FacetValueChildList();
                childList.parse(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }

    }

    public String getLabel() {
        return label;
    }

    public String getUndoQueryString() {
        return undoQueryString;
    }
    
    public Boolean hasUndoQueryString() {
        return (undoQueryString != null && !"".equals(undoQueryString));
    }

    public String getQueryString() {
        return queryString;
    }
    
    public Boolean hasQueryString() {
        return (queryString != null && !"".equals(queryString));
    }

    public Long getCount() {
        return count;
    }

    public boolean isSelected() {
        return selected;
    }

    public boolean hasChildren() {
        return hasChildren;
    }

    public FacetValueChildList getChildList() {
        return childList;
    }
}
