/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FacetValueChild extends AbstractResultEntity{

    private static final String SELECTED_NODE = "selected";

    private static final String UNDOLINK_NODE = "undolink";

    private static final String COUNT_NODE = "count";

    private static final String LABEL_NODE = "label";

    private static final String LINK_NODE = "link";

    private boolean selected;

    private String undoLink;

    private String label;

    private String link;

    private Long count;

    public void parse(XMLEventReader reader) throws Exception {

        while( reader.hasNext() ) {
            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;

            StartElement element = nextEvent.asStartElement();

            String localPart = element.getName().getLocalPart();
            if( SELECTED_NODE.equals(localPart)) {
                String data = readData(reader);
                selected = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
            }
            else
            if(  (UNDOLINK_NODE.equals(localPart))) {
                undoLink = readData(reader);
                ResultParser.getNextEvent(reader);
            }
            else
            if (  (COUNT_NODE.equals(localPart))) {
                String data = readData(reader);
                count = ResultParser.strToLong(data);
                ResultParser.getNextEvent(reader);
            }
            else
            if (  (LABEL_NODE.equals(localPart))) {
                label = readData(reader);
                ResultParser.getNextEvent(reader);
            }
            else
            if (LINK_NODE.equals(localPart)) {
                link = readData(reader);
                ResultParser.getNextEvent(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
    }

    public boolean isSelected() {
        return selected;
    }

    public String getUndoLink() {
        return undoLink;
    }

    public String getLabel() {
        return label;
    }

    public String getLink() {
        return link;
    }

    public Long getCount() {
        return count;
    }
}
