/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FacetValueChildList implements ResultEntity {

    private static final String CHILD_NODE = "child";

    private List<FacetValueChild> children;

    public FacetValueChildList() {
        children = new ArrayList<FacetValueChild>();
    }

    public void parse(XMLEventReader reader) throws Exception {

        while( reader.hasNext() ) {

            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;

            StartElement element = nextEvent.asStartElement();

            if( element.getName().getLocalPart().equals(CHILD_NODE)) {
                FacetValueChild fvc = new FacetValueChild();
                fvc.parse(reader);
                children.add(fvc);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
    }

    public List<FacetValueChild> getChildren() {
        return children;
    }

}
