/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import java.util.ArrayList;
import java.util.List;

public class Menu implements ResultEntity {
    private static final String ITEM_NODE = "item";
    private static final String NAME_NODE = "name";
    
    private String         name;
    private List<MenuItem> items;
    
    public Menu() {
        items = new ArrayList<MenuItem>();
    }

    public void parse(XMLEventReader reader) throws Exception {
        while( reader.hasNext() ) {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if( event.isEndElement())
                break;
            
            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();
            if( NAME_NODE.equals(localPart)) {
                name = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
            }
            else if( ITEM_NODE.equals(localPart)) {
                boolean selected = ResultParser.isSelected(startElement);
                
                MenuItem item = new MenuItem( selected );
                item.parse(reader);
                items.add(item);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
    }

    public String getName() {
        return name;
    }
    
    public List<MenuItem> getItems() {
        return items;
    }
}
