/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageList implements ResultEntity {
    private static final String POSITION_NODE = "position";
    private static final String PAGE_NODE = "page";
    private static final Logger LOG = LoggerFactory.getLogger(PageList.class);

    private List<ResultPage> pages;
    
    public PageList() {
        pages = new ArrayList<ResultPage>();
    }
    
    public List<ResultPage> getPages() {
        return pages;
    }
    
    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing page list");
        while( reader.hasNext() ) {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if( event.isEndElement())
                break;

            StartElement element = event.asStartElement();
            if( element.getName().getLocalPart().equals(PAGE_NODE)) {
                String position = element.getAttributeByName(new QName(POSITION_NODE)).getValue();
                boolean selected = ResultParser.isSelected(element);

                ResultPage page = new ResultPage(position, selected);
                page.parse(reader);
                pages.add(page);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        } 
    }
}
