/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pagination extends AbstractResultEntity{
    private static final Logger LOG = LoggerFactory.getLogger(Pagination.class);
    private static final String TOTAL_PAGES_NODE = "total-pages";
    private static final String PAGES_NODE          = "pages";
    
    private Long     totalPages;
    private PageList pageList;
    
    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing pagination information");
        while( reader.hasNext() ) {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if( event.isEndElement())
                break;
            
            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();
            LOG.debug("Parsing node {}", localPart);
            if( localPart.equals(TOTAL_PAGES_NODE)) {
                totalPages = Long.parseLong(readData(reader));
                ResultParser.getNextEvent(reader);
            }
            else
            if( localPart.equals(PAGES_NODE)) {
                pageList = new PageList();
                pageList.parse(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
    }

    public Long getTotalPages() {
        return totalPages;
    }
    
    public List<ResultPage> getResultPages() {
        List<ResultPage> pages = new ArrayList<ResultPage>();
        for(ResultPage p : pageList.getPages()) {
            if(p.getPosition().matches("\\d+")) {
                pages.add(p);
            }
        }
        return pages;
    }
    
    public ResultPage getFirst() {
        return get("first");
    }
    
    public ResultPage getLast() {
        return get("last");
    }
    
    public ResultPage getPrevious() {
        return get("previous");
    }
    
    public ResultPage getNext() {
        return get("next");
    }
    
    public ResultPage getViewall() {
        return get("viewall");
    }
    
    public Boolean hasNext() {
        return checkFor("next");
    }
    
    public Boolean hasPrevious() {
        return checkFor("previous");
    }
    
    public Boolean hasFirst() {
        return checkFor("first");
    }
    
    public Boolean hasLast() {
        return checkFor("last");
    }
    
    public Boolean hasViewall() {
        return checkFor("viewall");
    }
    
    public Integer getSize() {
        return pageList.getPages().size();
    }
    
    private ResultPage get(String position) {
        for(ResultPage p : pageList.getPages()) {
            if(position.equalsIgnoreCase(p.getPosition())) {
                return p;
            }
        }
        return null;
    }
    
    private Boolean checkFor(String position) {
        return (get(position) != null);
    }
}
