/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query implements ResultEntity {

    private static final Logger LOG = LoggerFactory.getLogger(Query.class);

    private static final String USER_QUERY_NODE    = "user-query";
    private static final String UPPER_RESULTS_NODE = "upper-results";
    private static final String LOWER_RESULTS_NODE = "lower-results";
    private static final String TOTAL_RESULTS_NODE = "total-results";
    
    private String userQuery;
    private Long   upperResult;
    private Long   lowerResult;
    private Long   totalResults;
    
    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing the query snippet");
        while( reader.hasNext() ) {
            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;
            
            StartElement element = nextEvent.asStartElement();
            String nodeName = element.getName().getLocalPart();
            LOG.debug("Parsing node {}", nodeName);
            if( nodeName.equals(USER_QUERY_NODE)) {
                String data = reader.nextEvent().asCharacters().getData();
                userQuery = (data != null) ? new String(data.getBytes("UTF-8"), "UTF-8") : null;
                ResultParser.getNextEvent(reader);
            }
            else
            if( nodeName.equals(UPPER_RESULTS_NODE)) {
                String data = reader.nextEvent().asCharacters().getData();
                upperResult = Long.parseLong( data );
                ResultParser.getNextEvent(reader);
            }
            else
            if( nodeName.equals(LOWER_RESULTS_NODE)) {
                String data = reader.nextEvent().asCharacters().getData();
                lowerResult = Long.parseLong( data );
                ResultParser.getNextEvent(reader);
            }
            else
            if( nodeName.equals(TOTAL_RESULTS_NODE)) {
                String data = reader.nextEvent().asCharacters().getData();
                totalResults = Long.parseLong( data );
                ResultParser.getNextEvent(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
        LOG.debug("Results parsed");
    }

    public String getUserQuery() {
        return userQuery;
    }

    public Long getUpperResult() {
        return upperResult;
    }

    public Long getLowerResult() {
        return lowerResult;
    }

    public Long getTotalResults() {
        return totalResults;
    }
}
