/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.events.StartElement;

public class Result implements ResultEntity {
    private static final String FIELD_NODE = "field";
    private List<Field> fields;
    
    
    public Result() {
        fields = new ArrayList<Field>();
    }
    
    public void parse(XMLEventReader reader) throws Exception {
        while( reader.hasNext()) {
            XMLEvent event;
            while( ( event = reader.peek() ).isCharacters() )
                reader.nextEvent();
            if( event.isEndElement()) {
                ResultParser.getNextEvent(reader);
                break;
            }

            StartElement element = event.asStartElement();
            if( element.getName().getLocalPart().equals(FIELD_NODE)) {
                Field field = new Field();
                field.parse(reader);
                fields.add(field);
            } 
            else {
                ResultParser.getNextEvent(reader);
                ResultParser.parseUnknownTag(reader);
            }
        }
    }
    
    public List<Field> getCustomFields() {
        return fields;
    }
    
    public String getTitle() {
        return get("title");
    }
    
    public String getDescription() {
        return get("description");
    }
    
    public String getLink() {
        return get("loc");
    }
    
    public String getTags() {
        return get("tags");
    }
    
    public String get(String key) {
        return get(key, "");
    }
    
    public String get(String key, String defaultValue) {
        String value = getField(key);
         return (value != null) ? value : defaultValue;
    }
    
    private String getField(String key) {
        for(Field field : fields) {
            if(key.equals(field.getName())) {
                return field.getValue();
            }
        }
        return null;
    }
}
