/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;

public class ResultPage implements ResultEntity {
    
    public static final String POSITION_FIRST = "first";
    public static final String POSITION_LAST = "last";
    public static final String POSITION_PREVIOUS = "previous";
    public static final String POSITION_NEXT = "next";
    public static final String POSITION_VIEWALL = "viewall";
    
    private String  position;
    private boolean selected;
    private String  queryString;
    
    public ResultPage(String position, boolean selected) {
        this.position = position;
        this.selected = selected;
    }

    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent event = reader.nextEvent();
        if( event.isEndElement())
            return;
        
        queryString = event.asCharacters().getData();
        ResultParser.getNextEvent(reader);
    }

    public String getPosition() {
        return position;
    }

    public boolean isSelected() {
        return selected;
    }

    public String getQueryString() {
        return queryString;
    }
    
    public Boolean hasQueryString() {
        return (queryString != null && !"".equals(queryString));
    }
}
